/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Network.Packet;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Server.Protocol.PacketObjectIn;
import net.ME1312.SubData.Server.Protocol.PacketObjectOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubServer;

public class PacketExCreateServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private UUID player;
    private String name;
    private SubCreator.ServerTemplate template;
    private Version version;
    private int port;
    private Boolean mode;
    private UUID log;
    private UUID tracker = null;

    public PacketExCreateServer(String name) {
        this.name = name;
    }

    @SafeVarargs
    public PacketExCreateServer(UUID player, SubServer server, SubCreator.ServerTemplate template, Version version, UUID log, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Object[]{server, template, log, callback});
        this.player = player;
        this.name = server.getName();
        this.template = template;
        this.version = version;
        this.port = server.getAddress().getPort();
        this.mode = template == server.getTemplate();
        this.log = log;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    @SafeVarargs
    public PacketExCreateServer(UUID player, String name, SubCreator.ServerTemplate template, Version version, int port, UUID log, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Object[]{name, template, port, log, callback});
        this.player = player;
        this.name = name;
        this.template = template;
        this.version = version;
        this.port = port;
        this.mode = null;
        this.log = log;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    public ObjectMap<Integer> send(SubDataClient client) {
        ObjectMap data = new ObjectMap();
        if (this.tracker == null) {
            data.set((Object)1, (Object)this.name);
        } else {
            data.set((Object)0, (Object)this.tracker);
            data.set((Object)2, (Object)this.name);
            if (this.template.isDynamic()) {
                ObjectMap template = new ObjectMap();
                template.set((Object)"name", (Object)this.template.getName());
                template.set((Object)"display", (Object)this.template.getDisplayName());
                template.set((Object)"enabled", (Object)this.template.isEnabled());
                template.set((Object)"icon", (Object)this.template.getIcon());
                template.set((Object)"dir", (Object)this.template.getDirectory().toString());
                template.set((Object)"build", (Object)this.template.getBuildOptions().clone());
                template.set((Object)"def", (Object)this.template.getConfigOptions().clone());
                data.set((Object)3, (Object)template);
            } else {
                data.set((Object)3, (Object)this.template.getName());
            }
            data.set((Object)4, (Object)this.version);
            data.set((Object)5, (Object)this.port);
            data.set((Object)6, (Object)this.log);
            if (this.mode != null) {
                data.set((Object)7, (Object)this.mode);
            }
            if (this.player != null) {
                data.set((Object)8, (Object)this.player);
            }
        }
        return data;
    }

    public void receive(SubDataClient client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

