/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Network.Packet;

import java.util.Map;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Protocol.PacketObjectIn;
import net.ME1312.SubData.Server.Protocol.PacketObjectOut;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.SubProxy;

public class PacketStartServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private SubProxy plugin;
    private int response;
    private String extra;
    private UUID tracker;

    public PacketStartServer(SubProxy plugin) {
        this.plugin = (SubProxy)((Object)Util.nullpo((Object)((Object)plugin)));
    }

    public PacketStartServer(int response, UUID tracker) {
        this(response, null, tracker);
    }

    public PacketStartServer(int response, String extra, UUID tracker) {
        this.response = response;
        this.extra = extra;
        this.tracker = tracker;
    }

    public ObjectMap<Integer> send(SubDataClient client) {
        ObjectMap json = new ObjectMap();
        if (this.tracker != null) {
            json.set((Object)0, (Object)this.tracker);
        }
        json.set((Object)1, (Object)this.response);
        if (this.extra != null) {
            json.set((Object)2, (Object)this.extra);
        }
        return json;
    }

    public void receive(SubDataClient client, ObjectMap<Integer> data) {
        UUID tracker = data.contains((Object)0) ? data.getUUID((Object)0) : null;
        try {
            String name = data.getString((Object)1);
            UUID player = data.contains((Object)2) ? data.getUUID((Object)2) : null;
            Map<String, Server> servers = this.plugin.api.getServers();
            if (!servers.containsKey(name.toLowerCase())) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(3, tracker)});
            } else if (!(servers.get(name.toLowerCase()) instanceof SubServer)) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(4, tracker)});
            } else if (!((SubServer)servers.get(name.toLowerCase())).getHost().isAvailable()) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(5, tracker)});
            } else if (!((SubServer)servers.get(name.toLowerCase())).getHost().isEnabled()) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(6, tracker)});
            } else if (!((SubServer)servers.get(name.toLowerCase())).isAvailable()) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(7, tracker)});
            } else if (!((SubServer)servers.get(name.toLowerCase())).isEnabled()) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(8, tracker)});
            } else if (((SubServer)servers.get(name.toLowerCase())).isRunning()) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(9, tracker)});
            } else if (((SubServer)servers.get(name.toLowerCase())).getCurrentIncompatibilities().size() != 0) {
                String list = "";
                for (SubServer server : ((SubServer)servers.get(name.toLowerCase())).getCurrentIncompatibilities()) {
                    if (list.length() != 0) {
                        list = list + ", ";
                    }
                    list = list + server.getName();
                }
                client.sendPacket(new PacketOut[]{new PacketStartServer(10, list, tracker)});
            } else if (((SubServer)servers.get(name.toLowerCase())).start(player)) {
                client.sendPacket(new PacketOut[]{new PacketStartServer(0, tracker)});
            } else {
                client.sendPacket(new PacketOut[]{new PacketStartServer(1, tracker)});
            }
        }
        catch (Throwable e) {
            client.sendPacket(new PacketOut[]{new PacketStartServer(2, tracker)});
            e.printStackTrace();
        }
    }
}

