/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee;

import com.google.common.collect.Range;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Server.DataProtocol;
import net.ME1312.SubData.Server.DataServer;
import net.ME1312.SubServers.Bungee.BungeeAPI;
import net.ME1312.SubServers.Bungee.Event.SubAddHostEvent;
import net.ME1312.SubServers.Bungee.Event.SubAddServerEvent;
import net.ME1312.SubServers.Bungee.Event.SubRemoveHostEvent;
import net.ME1312.SubServers.Bungee.Event.SubRemoveServerEvent;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Proxy;
import net.ME1312.SubServers.Bungee.Host.RemotePlayer;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Host.ServerImpl;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidHostException;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.protocol.ProtocolConstants;

public final class SubAPI
implements BungeeAPI {
    LinkedList<Runnable> reloadListeners = new LinkedList();
    private static HashMap<String, Object> knownSignatures = new HashMap();
    private final SubProxy plugin;
    private static SubAPI api;
    private final Version[] GAME_VERSION;

    SubAPI(SubProxy plugin) {
        this.plugin = plugin;
        this.GAME_VERSION = this.getGameVersion();
        api = this;
    }

    public static SubAPI getInstance() {
        return api;
    }

    @Deprecated
    public SubProxy getInternals() {
        return this.plugin;
    }

    public void addListener(Runnable reload) {
        if (reload != null) {
            this.reloadListeners.add(reload);
        }
    }

    public DataServer getSubDataNetwork() {
        return this.plugin.subdata;
    }

    public DataProtocol getSubDataProtocol() {
        return this.plugin.subprotocol;
    }

    public void addHostDriver(Class<? extends Host> driver, String handle) {
        Util.nullpo((Object[])new Serializable[]{driver, handle});
        if (this.plugin.hostDrivers.containsKey(handle.toUpperCase().replace('-', '_').replace(' ', '_'))) {
            throw new IllegalStateException("Driver already exists: " + handle);
        }
        this.plugin.hostDrivers.put(handle.toUpperCase().replace('-', '_').replace(' ', '_'), driver);
    }

    public List<String> getHostDrivers() {
        return new LinkedList<String>(this.plugin.hostDrivers.keySet());
    }

    public Map<String, Host> getHosts() {
        return new TreeMap<String, Host>(this.plugin.hosts);
    }

    public Host getHost(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        return this.plugin.hosts.get(name.toLowerCase());
    }

    public Host addHost(String driver, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.addHost(null, driver, name, enabled, ports, log, address, directory, gitBash);
    }

    public Host addHost(UUID player, String driver, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Util.nullpo((Object[])new Serializable[]{driver, name, Boolean.valueOf(enabled), ports, Boolean.valueOf(log), address, directory, gitBash});
        if (!this.getHostDrivers().contains(driver.toUpperCase().replace('-', '_').replace(' ', '_'))) {
            throw new InvalidHostException("Invalid Driver for host: " + name);
        }
        return this.addHost(player, this.plugin.hostDrivers.get(driver.toUpperCase().replace('-', '_').replace(' ', '_')), name, enabled, ports, log, address, directory, gitBash);
    }

    public Host addHost(Class<? extends Host> driver, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.addHost(null, driver, name, enabled, ports, log, address, directory, gitBash);
    }

    public Host addHost(UUID player, Class<? extends Host> driver, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Util.nullpo((Object[])new Serializable[]{driver, name, Boolean.valueOf(enabled), ports, Boolean.valueOf(log), address, directory, gitBash});
        Host host = this.plugin.constructHost(driver, name, enabled, ports, log, address, directory, gitBash);
        return this.addHost(player, host) ? host : null;
    }

    public boolean addHost(Host host) {
        return this.addHost(null, host);
    }

    public boolean addHost(UUID player, Host host) {
        SubAddHostEvent event = new SubAddHostEvent(player, host);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.plugin.hosts.put(host.getName().toLowerCase(), host);
            return true;
        }
        return false;
    }

    public boolean removeHost(String name) {
        return this.removeHost(null, name);
    }

    public boolean removeHost(UUID player, String name) {
        Util.nullpo((Object[])new Object[]{name, this.getHost(name)});
        SubRemoveHostEvent event = new SubRemoveHostEvent(player, this.getHost(name));
        this.plugin.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (this.getHost(name).destroy()) {
                this.plugin.hosts.remove(name.toLowerCase());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean forceRemoveHost(String name) {
        return this.forceRemoveHost(null, name);
    }

    public boolean forceRemoveHost(UUID player, String name) {
        Util.nullpo((Object[])new Object[]{name, this.getHost(name)});
        SubRemoveHostEvent event = new SubRemoveHostEvent(player, this.getHost(name));
        this.plugin.getPluginManager().callEvent((Event)event);
        if (this.getHost(name).destroy()) {
            this.plugin.hosts.remove(name.toLowerCase());
            return true;
        }
        return false;
    }

    public Map<String, List<Server>> getGroups() {
        TreeMap<String, List<Server>> groups = new TreeMap<String, List<Server>>();
        HashMap<String, String> conflitresolver = new HashMap<String, String>();
        for (Server server : this.getServers().values()) {
            Iterator<String> iterator = server.getGroups().iterator();
            while (iterator.hasNext()) {
                String name;
                String group = name = iterator.next();
                if (conflitresolver.containsKey(name.toLowerCase())) {
                    group = (String)conflitresolver.get(name.toLowerCase());
                } else {
                    conflitresolver.put(name.toLowerCase(), name);
                }
                List<Object> list = groups.containsKey(group) ? groups.get(group) : new LinkedList();
                list.add(server);
                groups.put(group, list);
            }
        }
        return groups;
    }

    public Map<String, List<Server>> getLowercaseGroups() {
        Map<String, List<Server>> groups = this.getGroups();
        TreeMap<String, List<Server>> lowercaseGroups = new TreeMap<String, List<Server>>();
        for (String key : groups.keySet()) {
            lowercaseGroups.put(key.toLowerCase(), groups.get(key));
        }
        return lowercaseGroups;
    }

    public Pair<String, List<Server>> getGroup(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        for (Map.Entry<String, List<Server>> group : this.getLowercaseGroups().entrySet()) {
            if (!group.getKey().equalsIgnoreCase(name)) continue;
            return new ContainedPair((Object)group.getKey(), group.getValue());
        }
        return null;
    }

    public Map<String, Server> getServers() {
        TreeMap<String, Server> servers = new TreeMap<String, Server>();
        servers.putAll(this.plugin.exServers);
        for (Host host : this.plugin.hosts.values()) {
            servers.putAll(host.getSubServers());
        }
        return servers;
    }

    public Server getServer(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        Server server = this.plugin.exServers.getOrDefault(name.toLowerCase(), null);
        return server == null ? this.getSubServer(name) : server;
    }

    public Server addServer(String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted) {
        return this.addServer(null, name, ip, port, motd, hidden, restricted);
    }

    public Server addServer(UUID player, String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted) {
        ServerImpl server = ServerImpl.construct(name, new InetSocketAddress(ip, port), motd, hidden, restricted);
        return this.addServer(player, server) ? server : null;
    }

    public boolean addServer(Server server) {
        return this.addServer(null, server);
    }

    public boolean addServer(UUID player, Server server) {
        if (this.getServers().containsKey(server.getName().toLowerCase())) {
            throw new InvalidServerException("A Server already exists with this name!");
        }
        SubAddServerEvent event = new SubAddServerEvent(player, null, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.plugin.exServers.put(server.getName().toLowerCase(), server);
            return true;
        }
        return false;
    }

    public boolean removeServer(String name) {
        return this.removeServer(null, name);
    }

    public boolean removeServer(UUID player, String name) {
        Util.nullpo((Object)name);
        Server server = this.getServer(name);
        if (server == null) {
            return true;
        }
        SubRemoveServerEvent event = new SubRemoveServerEvent(player, null, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.plugin.exServers.remove(name.toLowerCase());
            return true;
        }
        return false;
    }

    public boolean forceRemoveServer(String name) {
        return this.forceRemoveServer(null, name);
    }

    public boolean forceRemoveServer(UUID player, String name) {
        Util.nullpo((Object)name);
        Server server = this.getServer(name);
        if (server == null) {
            return true;
        }
        SubRemoveServerEvent event = new SubRemoveServerEvent(player, null, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        this.plugin.exServers.remove(name.toLowerCase());
        return true;
    }

    public Map<String, SubServer> getSubServers() {
        TreeMap<String, SubServer> servers = new TreeMap<String, SubServer>();
        for (Host host : this.plugin.hosts.values()) {
            servers.putAll(host.getSubServers());
        }
        return servers;
    }

    public SubServer getSubServer(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        for (Host host : this.plugin.hosts.values()) {
            SubServer server = host.getSubServer(name);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public Map<String, Proxy> getProxies() {
        return new TreeMap<String, Proxy>(this.plugin.proxies);
    }

    public Proxy getProxy(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        Proxy proxy = this.plugin.proxies.getOrDefault(name.toLowerCase(), null);
        if (proxy == null && this.plugin.mProxy != null && this.plugin.mProxy.getName().equalsIgnoreCase(name)) {
            proxy = this.plugin.mProxy;
        }
        return proxy;
    }

    public Proxy getMasterProxy() {
        return this.plugin.mProxy;
    }

    public int getRemotePlayerCount() {
        return this.plugin.rPlayers.size();
    }

    public Map<UUID, RemotePlayer> getRemotePlayers(ServerInfo server) {
        if (server instanceof Server) {
            HashMap<UUID, RemotePlayer> players = new HashMap<UUID, RemotePlayer>();
            for (UUID id : Util.getBackwards(this.plugin.rPlayerLinkS, (Object)((Server)server))) {
                players.put(id, this.plugin.rPlayers.get(id));
            }
            return players;
        }
        return Collections.emptyMap();
    }

    public Map<UUID, RemotePlayer> getRemotePlayers() {
        return new HashMap<UUID, RemotePlayer>(this.plugin.rPlayers);
    }

    public RemotePlayer getRemotePlayer(String name) {
        Util.nullpo((Object)name);
        for (RemotePlayer player : this.plugin.rPlayers.values()) {
            if (!player.getName().equalsIgnoreCase(name)) continue;
            return player;
        }
        return null;
    }

    public RemotePlayer getRemotePlayer(UUID id) {
        Util.nullpo((Object)id);
        return this.plugin.rPlayers.getOrDefault(id, null);
    }

    public void setLang(String channel, String key, String value) {
        Util.nullpo((Object[])new String[]{channel, key, value});
        LinkedHashMap<String, String> map = this.plugin.exLang.containsKey(channel.toLowerCase()) ? this.plugin.exLang.get(channel.toLowerCase()) : new LinkedHashMap<String, String>();
        map.put(key, value);
        this.plugin.exLang.put(channel.toLowerCase(), map);
    }

    public Collection<String> getLangChannels() {
        return this.plugin.exLang.keySet();
    }

    public Map<String, String> getLang(String channel) {
        if (Util.isNull((Object)channel)) {
            return null;
        }
        return new LinkedHashMap<String, String>((Map)this.plugin.exLang.get(channel.toLowerCase()));
    }

    public String signAnonymousObject() {
        return this.plugin.getNewSignature();
    }

    public String signObject(Object object) {
        if (object == null) {
            return "";
        }
        String signature = this.signAnonymousObject();
        knownSignatures.put(signature, object);
        return signature;
    }

    public <R> R getObjectBySignature(String signature) {
        Util.nullpo((Object)signature);
        return knownSignatures.getOrDefault(signature, null);
    }

    public void invalidateObjectSignature(String signature) {
        knownSignatures.remove(signature);
    }

    public File getRuntimeDirectory() {
        return this.plugin.dir;
    }

    public Version getWrapperVersion() {
        return SubProxy.version;
    }

    public Version getWrapperBuild() {
        return SubProxy.class.getPackage().getSpecificationTitle() != null ? new Version(SubProxy.class.getPackage().getSpecificationTitle()) : null;
    }

    public Version getProxyVersion() {
        return new Version(this.plugin.getVersion());
    }

    public Version[] getGameVersion() {
        if (this.GAME_VERSION == null) {
            if (System.getProperty("subservers.minecraft.version", "").length() > 0) {
                return new Version[]{new Version(System.getProperty("subservers.minecraft.version"))};
            }
            if (((Boolean)Try.all.get(() -> ProtocolConstants.SUPPORTED_VERSIONS != null, (Object)false)).booleanValue()) {
                LinkedList<Version> versions = new LinkedList<Version>();
                for (String version : ProtocolConstants.SUPPORTED_VERSIONS) {
                    versions.add(new Version(version));
                }
                Collections.sort(versions);
                return versions.toArray(new Version[versions.size()]);
            }
            if (((Boolean)Try.all.get(() -> this.plugin.getGameVersion() != null, (Object)false)).booleanValue()) {
                String raw = this.plugin.getGameVersion();
                if (raw.contains("-") || raw.contains(",")) {
                    LinkedList<Version> versions = new LinkedList<Version>();
                    for (String version : raw.split("(?:\\s*-|,)\\s*")) {
                        versions.add(new Version(version));
                    }
                    Collections.sort(versions);
                    return versions.toArray(new Version[versions.size()]);
                }
                return new Version[]{new Version(this.plugin.getGameVersion())};
            }
            this.plugin.getLogger().warning("Could not determine compatible Minecraft version(s); Now using 1.x.x as a placeholder.");
            this.plugin.getLogger().warning("Use this launch argument to specify a compatible Minecraft version: -Dsubservers.minecraft.version=1.x.x");
            return new Version[]{new Version("1.x.x")};
        }
        return this.GAME_VERSION;
    }
}

