/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Platform;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Server.ClientHandler;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Proxy;
import net.ME1312.SubServers.Bungee.Host.RemotePlayer;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketCheckPermission;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.md_5.bungee.command.ConsoleCommandSender;

public final class SubCommand
extends Command
implements TabExecutor {
    static HashMap<UUID, HashMap<ServerInfo, Pair<Long, Boolean>>> players = new HashMap();
    private static Thread reload;
    private SubProxy plugin;
    private String label;

    SubCommand(SubProxy plugin, String command) {
        super(command);
        this.plugin = plugin;
        this.label = '/' + command;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof ProxiedPlayer)) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                    sender.sendMessages(this.printHelp());
                } else if (args[0].equalsIgnoreCase("version") || args[0].equalsIgnoreCase("ver")) {
                    sender.sendMessage("SubServers > These are the platforms and versions that are running SubServers.Bungee:");
                    sender.sendMessage("  " + Platform.getSystemName() + ' ' + Platform.getSystemVersion() + (Platform.getSystemBuild() != null ? " (" + Platform.getSystemBuild() + ')' : "") + (!Platform.getSystemArchitecture().equals("unknown") ? " [" + Platform.getSystemArchitecture() + ']' : "") + ',');
                    sender.sendMessage("  Java " + Platform.getJavaVersion() + (!Platform.getJavaArchitecture().equals("unknown") ? " [" + Platform.getJavaArchitecture() + ']' : "") + ',');
                    sender.sendMessage("  " + this.plugin.getBungeeName() + ' ' + this.plugin.getVersion() + (this.plugin.isPatched ? " [Patched]" : "") + ',');
                    sender.sendMessage("  SubServers.Bungee v" + SubProxy.version.toExtendedString() + (this.plugin.api.getWrapperBuild() != null ? " (" + this.plugin.api.getWrapperBuild() + ')' : ""));
                    sender.sendMessage("");
                    new Thread(() -> {
                        try {
                            ObjectMap tags = new ObjectMap((Map)new Gson().fromJson("{\"tags\":" + Util.readAll((Reader)new BufferedReader(new InputStreamReader(new URL("https://api.github.com/repos/ME1312/SubServers-2/git/refs/tags").openStream(), Charset.forName("UTF-8")))) + '}', Map.class));
                            LinkedList<Version> versions = new LinkedList<Version>();
                            Version updversion = SubProxy.version;
                            int updcount = 0;
                            for (ObjectMap tag : tags.getMapList((Object)"tags")) {
                                versions.add(Version.fromString((String)tag.getString((Object)"ref").substring(10)));
                            }
                            Collections.sort(versions);
                            for (Version version : versions) {
                                if (version.compareTo(updversion) <= 0) continue;
                                updversion = version;
                                ++updcount;
                            }
                            if (updcount == 0) {
                                sender.sendMessage("You are on the latest version.");
                            } else {
                                sender.sendMessage("SubServers.Bungee v" + updversion + " is available. You are " + updcount + " version" + (updcount == 1 ? "" : "s") + " behind.");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }, "SubServers.Bungee::Update_Check").start();
                } else if (args[0].equalsIgnoreCase("reload")) {
                    if (reload == null || !reload.isAlive()) {
                        reload = new Thread(() -> {
                            if (args.length > 1) {
                                switch (args[1].toLowerCase()) {
                                    case "hard": 
                                    case "system": 
                                    case "subdata": 
                                    case "network": {
                                        this.plugin.stopListeners();
                                        this.plugin.getLogger().info("Closing player connections");
                                        for (ProxiedPlayer player : this.plugin.getPlayers()) {
                                            Try.all.run(() -> player.disconnect(this.plugin.getTranslation("restart", new Object[0])));
                                        }
                                        this.plugin.shutdown();
                                    }
                                    case "*": 
                                    case "all": 
                                    case "soft": 
                                    case "bungee": 
                                    case "bungeecord": 
                                    case "plugin": 
                                    case "plugins": {
                                        this.plugin.getPluginManager().dispatchCommand((CommandSender)ConsoleCommandSender.getInstance(), "greload");
                                        break;
                                    }
                                    case "host": 
                                    case "hosts": 
                                    case "server": 
                                    case "servers": 
                                    case "subserver": 
                                    case "subservers": 
                                    case "config": 
                                    case "configs": {
                                        try {
                                            this.plugin.reload();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        break;
                                    }
                                    case "creator": 
                                    case "creators": 
                                    case "subcreator": 
                                    case "subcreators": 
                                    case "template": 
                                    case "templates": {
                                        for (Host host : this.plugin.api.getHosts().values()) {
                                            host.getCreator().reload();
                                        }
                                        sender.sendMessage("SubServers > SubCreator instances reloaded");
                                        break;
                                    }
                                    default: {
                                        sender.sendMessage("SubServers > Unknown reload type: " + args[1]);
                                        break;
                                    }
                                }
                            } else {
                                try {
                                    this.plugin.reload();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }, "SubServers.Bungee::Reload_Command_Handler");
                        reload.start();
                    }
                } else if (args[0].equalsIgnoreCase("list")) {
                    String message;
                    String div = ChatColor.RESET + ", ";
                    int i = 0;
                    boolean sent = false;
                    if (this.plugin.api.getGroups().keySet().size() > 0) {
                        sender.sendMessage("SubServers > Group/Server List:");
                        for (String string : this.plugin.api.getGroups().keySet()) {
                            message = "  ";
                            message = message + ChatColor.GOLD + string + ChatColor.RESET + ": ";
                            ArrayList<String> names = new ArrayList<String>();
                            Map<String, Server> map = this.plugin.api.getServers();
                            for (Server server2 : (List)this.plugin.api.getGroup(string).value()) {
                                names.add(server2.getName());
                            }
                            Collections.sort(names);
                            Iterator iterator = names.iterator();
                            while (iterator.hasNext()) {
                                String name = (String)iterator.next();
                                if (i != 0) {
                                    message = message + div;
                                }
                                Server server3 = map.get(name.toLowerCase());
                                message = !(map.get(name.toLowerCase()) instanceof SubServer) ? message + ChatColor.WHITE : (((SubServer)server3).isRunning() ? (((SubServer)server3).getStopAction() == SubServer.StopAction.REMOVE_SERVER || ((SubServer)server3).getStopAction() == SubServer.StopAction.RECYCLE_SERVER || ((SubServer)server3).getStopAction() == SubServer.StopAction.DELETE_SERVER ? message + ChatColor.AQUA : message + ChatColor.GREEN) : (((SubServer)server3).getHost().isAvailable() && ((SubServer)server3).getHost().isEnabled() && ((SubServer)server3).isAvailable() && ((SubServer)server3).isEnabled() && ((SubServer)server3).getCurrentIncompatibilities().size() == 0 ? message + ChatColor.YELLOW : message + ChatColor.RED));
                                message = message + server3.getDisplayName() + (server3.getName().equals(server3.getDisplayName()) ? "" : " [" + server3.getName() + ']');
                                ++i;
                            }
                            if (i == 0) {
                                message = message + ChatColor.RESET + "(none)";
                            }
                            sender.sendMessage(message);
                            i = 0;
                            sent = true;
                        }
                        if (!sent) {
                            sender.sendMessage(ChatColor.RESET + "(none)");
                        }
                        sent = false;
                    }
                    sender.sendMessage("SubServers > Host/SubServer List:");
                    for (Host host : this.plugin.api.getHosts().values()) {
                        message = "  ";
                        message = host.isAvailable() && host.isEnabled() ? message + ChatColor.AQUA : message + ChatColor.RED;
                        message = message + host.getDisplayName() + " [" + (host.getName().equals(host.getDisplayName()) ? "" : host.getName() + ChatColor.stripColor((String)div)) + host.getAddress().getHostAddress() + "]" + ChatColor.RESET + ": ";
                        for (SubServer subServer : host.getSubServers().values()) {
                            if (i != 0) {
                                message = message + div;
                            }
                            message = subServer.isRunning() ? (subServer.getStopAction() == SubServer.StopAction.REMOVE_SERVER || subServer.getStopAction() == SubServer.StopAction.RECYCLE_SERVER || subServer.getStopAction() == SubServer.StopAction.DELETE_SERVER ? message + ChatColor.AQUA : message + ChatColor.GREEN) : (subServer.getHost().isAvailable() && subServer.getHost().isEnabled() && subServer.isAvailable() && subServer.isEnabled() && subServer.getCurrentIncompatibilities().size() == 0 ? message + ChatColor.YELLOW : message + ChatColor.RED);
                            message = message + subServer.getDisplayName() + " [" + (subServer.getName().equals(subServer.getDisplayName()) ? "" : subServer.getName() + ChatColor.stripColor((String)div)) + subServer.getAddress().getPort() + "]";
                            ++i;
                        }
                        if (i == 0) {
                            message = message + ChatColor.RESET + "(none)";
                        }
                        sender.sendMessage(message);
                        i = 0;
                        sent = true;
                    }
                    if (!sent) {
                        sender.sendMessage(ChatColor.RESET + "(none)");
                    }
                    sender.sendMessage("SubServers > Server List:");
                    String message2 = "  ";
                    for (Server server4 : this.plugin.api.getServers().values()) {
                        if (server4 instanceof SubServer) continue;
                        if (i != 0) {
                            message2 = message2 + div;
                        }
                        message2 = message2 + ChatColor.WHITE + server4.getDisplayName() + " [" + (server4.getName().equals(server4.getDisplayName()) ? "" : server4.getName() + ChatColor.stripColor((String)div)) + server4.getAddress().getAddress().getHostAddress() + ':' + server4.getAddress().getPort() + "]";
                        ++i;
                    }
                    if (i == 0) {
                        message2 = message2 + ChatColor.RESET + "(none)";
                    }
                    sender.sendMessage(message2);
                    if (this.plugin.api.getProxies().keySet().size() > 0) {
                        sender.sendMessage("SubServers > Proxy List:");
                        message2 = "  (master)";
                        for (Proxy proxy : this.plugin.api.getProxies().values()) {
                            message2 = message2 + div;
                            message2 = proxy.getSubData()[0] != null ? message2 + ChatColor.AQUA : message2 + ChatColor.RED;
                            message2 = message2 + proxy.getDisplayName() + (proxy.getName().equals(proxy.getDisplayName()) ? "" : " [" + proxy.getName() + ']');
                        }
                        sender.sendMessage(message2);
                    }
                } else if (args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("status")) {
                    if (args.length > 1) {
                        String type = args.length > 2 ? args[1] : null;
                        String name = args[type != null ? 2 : 1];
                        Runnable getPlayer = () -> {
                            RemotePlayer player = this.plugin.api.getRemotePlayer(name);
                            if (player != null) {
                                sender.sendMessage("SubServers > Info on player: " + ChatColor.WHITE + player.getName());
                                if (player.getProxy() != null) {
                                    sender.sendMessage(" -> Proxy: " + ChatColor.WHITE + player.getProxy().getName());
                                }
                                if (player.getServer() != null) {
                                    sender.sendMessage(" -> Server: " + ChatColor.WHITE + player.getServer().getName());
                                }
                                if (player.getAddress() != null) {
                                    sender.sendMessage(" -> Address: " + ChatColor.WHITE + player.getAddress().getAddress().getHostAddress() + ':' + player.getAddress().getPort());
                                }
                                sender.sendMessage(" -> UUID: " + ChatColor.AQUA + player.getUniqueId());
                            } else if (type == null) {
                                sender.sendMessage("SubServers > There is no object with that name");
                            } else {
                                sender.sendMessage("SubServers > There is no player with that name");
                            }
                        };
                        Runnable getServer = () -> {
                            Server server = this.plugin.api.getServer(name);
                            if (server != null) {
                                sender.sendMessage("SubServers > Info on " + (server instanceof SubServer ? "sub" : "") + "server: " + ChatColor.WHITE + server.getDisplayName());
                                if (!server.getName().equals(server.getDisplayName())) {
                                    sender.sendMessage(" -> System Name: " + ChatColor.WHITE + server.getName());
                                }
                                if (server instanceof SubServer) {
                                    sender.sendMessage(" -> Available: " + (((SubServer)server).isAvailable() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    sender.sendMessage(" -> Enabled: " + (((SubServer)server).isEnabled() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    if (!((SubServer)server).isEditable()) {
                                        sender.sendMessage(" -> Editable: " + ChatColor.RED + "no");
                                    }
                                    sender.sendMessage(" -> Host: " + ChatColor.WHITE + ((SubServer)server).getHost().getName());
                                    if (((SubServer)server).getTemplate() != null) {
                                        sender.sendMessage(" -> Template: " + ChatColor.WHITE + ((SubServer)server).getTemplate().getName());
                                    }
                                }
                                if (server.getGroups().size() > 0) {
                                    sender.sendMessage(" -> Group" + (server.getGroups().size() > 1 ? "s:" : ": " + ChatColor.WHITE + server.getGroups().get(0)));
                                }
                                if (server.getGroups().size() > 1) {
                                    for (String group : server.getGroups()) {
                                        sender.sendMessage("      - " + ChatColor.WHITE + group);
                                    }
                                }
                                sender.sendMessage(" -> Address: " + ChatColor.WHITE + server.getAddress().getAddress().getHostAddress() + ':' + server.getAddress().getPort());
                                if (server instanceof SubServer) {
                                    sender.sendMessage(" -> " + (((SubServer)server).isOnline() ? "Online" : "Running") + ": " + (((SubServer)server).isRunning() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                }
                                if (!(server instanceof SubServer) || ((SubServer)server).isRunning()) {
                                    sender.sendMessage(" -> Connected: " + (server.getSubData()[0] != null ? ChatColor.GREEN + "yes" + (server.getSubData().length > 1 ? ChatColor.AQUA + " +" + (server.getSubData().length - 1) + " subchannel" + (server.getSubData().length == 2 ? "" : "s") : "") : ChatColor.RED + "no"));
                                    sender.sendMessage(" -> Players: " + ChatColor.AQUA + server.getRemotePlayers().size() + " online");
                                }
                                sender.sendMessage(" -> MOTD: " + ChatColor.WHITE + ChatColor.stripColor((String)server.getMotd()));
                                if (server instanceof SubServer) {
                                    if (((SubServer)server).getStopAction() != SubServer.StopAction.NONE) {
                                        sender.sendMessage(" -> Stop Action: " + ChatColor.WHITE + ((SubServer)server).getStopAction().toString());
                                    }
                                    if (((SubServer)server).isStopping()) {
                                        sender.sendMessage(" -> Stopping: " + ChatColor.GREEN + "yes");
                                    }
                                }
                                sender.sendMessage(" -> Signature: " + ChatColor.AQUA + server.getSignature());
                                if (server instanceof SubServer) {
                                    sender.sendMessage(" -> Logging: " + (((SubServer)server).isLogging() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                }
                                sender.sendMessage(" -> Restricted: " + (server.isRestricted() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                if (server instanceof SubServer && ((SubServer)server).getIncompatibilities().size() > 0) {
                                    ArrayList<String> current = new ArrayList<String>();
                                    for (SubServer other : ((SubServer)server).getCurrentIncompatibilities()) {
                                        current.add(other.getName().toLowerCase());
                                    }
                                    sender.sendMessage(" -> Incompatibilities:");
                                    for (SubServer other : ((SubServer)server).getIncompatibilities()) {
                                        sender.sendMessage("      - " + (current.contains(other.getName().toLowerCase()) ? ChatColor.WHITE : ChatColor.GRAY) + other);
                                    }
                                }
                                sender.sendMessage(" -> Hidden: " + (server.isHidden() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                            } else if (type == null) {
                                getPlayer.run();
                            } else {
                                sender.sendMessage("SubServers > There is no server with that name");
                            }
                        };
                        Runnable runnable = () -> {
                            Pair<String, List<Server>> group = this.plugin.api.getGroup(name);
                            if (group != null) {
                                sender.sendMessage("SubServers > Info on group: " + ChatColor.WHITE + (String)group.key());
                                sender.sendMessage(" -> Servers: " + (((List)group.value()).size() <= 0 ? ChatColor.GRAY + "(none)" : ChatColor.AQUA.toString() + ((List)group.value()).size()));
                                for (Server server : (List)group.value()) {
                                    sender.sendMessage("      - " + ChatColor.WHITE + server.getDisplayName() + (server.getName().equals(server.getDisplayName()) ? "" : " [" + server.getName() + ']'));
                                }
                            } else if (type == null) {
                                getServer.run();
                            } else {
                                sender.sendMessage("SubServers > There is no group with that name");
                            }
                        };
                        Runnable getHost = () -> {
                            Host host = this.plugin.api.getHost(name);
                            if (host != null) {
                                sender.sendMessage("SubServers > Info on host: " + ChatColor.WHITE + host.getDisplayName());
                                if (!host.getName().equals(host.getDisplayName())) {
                                    sender.sendMessage(" -> System Name: " + ChatColor.WHITE + host.getName());
                                }
                                sender.sendMessage(" -> Available: " + (host.isAvailable() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                sender.sendMessage(" -> Enabled: " + (host.isEnabled() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                sender.sendMessage(" -> Address: " + ChatColor.WHITE + host.getAddress().getHostAddress());
                                if (host instanceof ClientHandler) {
                                    sender.sendMessage(" -> Connected: " + (((ClientHandler)host).getSubData()[0] != null ? ChatColor.GREEN + "yes" + (((ClientHandler)host).getSubData().length > 1 ? ChatColor.AQUA + " +" + (((ClientHandler)host).getSubData().length - 1) + " subchannel" + (((ClientHandler)host).getSubData().length == 2 ? "" : "s") : "") : ChatColor.RED + "no"));
                                }
                                sender.sendMessage(" -> SubServers: " + (host.getSubServers().keySet().size() <= 0 ? ChatColor.GRAY + "(none)" : ChatColor.AQUA.toString() + host.getSubServers().keySet().size()));
                                for (SubServer subServer : host.getSubServers().values()) {
                                    sender.sendMessage("      - " + (subServer.isEnabled() ? ChatColor.WHITE : ChatColor.GRAY) + subServer.getDisplayName() + (subServer.getName().equals(subServer.getDisplayName()) ? "" : " [" + subServer.getName() + ']'));
                                }
                                sender.sendMessage(" -> Templates: " + (host.getCreator().getTemplates().keySet().size() <= 0 ? ChatColor.GRAY + "(none)" : ChatColor.AQUA.toString() + host.getCreator().getTemplates().keySet().size()));
                                for (SubCreator.ServerTemplate serverTemplate : host.getCreator().getTemplates().values()) {
                                    sender.sendMessage("      - " + (serverTemplate.isEnabled() ? ChatColor.WHITE : ChatColor.GRAY) + serverTemplate.getDisplayName() + (serverTemplate.getName().equals(serverTemplate.getDisplayName()) ? "" : " [" + serverTemplate.getName() + ']'));
                                }
                                sender.sendMessage(" -> Signature: " + ChatColor.AQUA + host.getSignature());
                            } else if (type == null) {
                                getGroup.run();
                            } else {
                                sender.sendMessage("SubServers > There is no host with that name");
                            }
                        };
                        Runnable getProxy = () -> {
                            Proxy proxy = this.plugin.api.getProxy(name);
                            if (proxy != null) {
                                sender.sendMessage("SubServers > Info on proxy: " + ChatColor.WHITE + proxy.getDisplayName());
                                if (!proxy.getName().equals(proxy.getDisplayName())) {
                                    sender.sendMessage(" -> System Name: " + ChatColor.WHITE + proxy.getName());
                                }
                                if (!proxy.isMaster()) {
                                    sender.sendMessage(" -> Connected: " + (proxy.getSubData()[0] != null ? ChatColor.GREEN + "yes" + (proxy.getSubData().length > 1 ? ChatColor.AQUA + " +" + (proxy.getSubData().length - 1) + " subchannel" + (proxy.getSubData().length == 2 ? "" : "s") : "") : ChatColor.RED + "no"));
                                } else if (!proxy.getDisplayName().toLowerCase().contains("master")) {
                                    sender.sendMessage(" -> Type: " + ChatColor.WHITE + "Master");
                                }
                                sender.sendMessage(" -> Players: " + ChatColor.AQUA + proxy.getPlayers().size() + " online");
                                sender.sendMessage(" -> Signature: " + ChatColor.AQUA + proxy.getSignature());
                            } else if (type == null) {
                                getHost.run();
                            } else {
                                sender.sendMessage("SubServers > There is no proxy with that name");
                            }
                        };
                        if (type == null) {
                            getProxy.run();
                        } else {
                            switch (type.toLowerCase()) {
                                case "p": 
                                case "proxy": {
                                    getProxy.run();
                                    break;
                                }
                                case "h": 
                                case "host": {
                                    getHost.run();
                                    break;
                                }
                                case "g": 
                                case "group": {
                                    runnable.run();
                                    break;
                                }
                                case "s": 
                                case "server": 
                                case "subserver": {
                                    getServer.run();
                                    break;
                                }
                                case "u": 
                                case "user": 
                                case "player": {
                                    getPlayer.run();
                                    break;
                                }
                                default: {
                                    sender.sendMessage("SubServers > There is no object type with that name");
                                }
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " [proxy|host|group|server|player] <Name>");
                    }
                } else if (args[0].equalsIgnoreCase("start")) {
                    if (args.length > 1) {
                        ServerSelection select = this.selectServers(sender, args, 1, true);
                        if (select.subservers.length > 0) {
                            int success = 0;
                            int running = 0;
                            for (SubServer server5 : select.subservers) {
                                if (!server5.getHost().isAvailable()) {
                                    sender.sendMessage("SubServers > The host for " + server5.getName() + " is not available");
                                    continue;
                                }
                                if (!server5.getHost().isEnabled()) {
                                    sender.sendMessage("SubServers > The host for " + server5.getName() + " is not enabled");
                                    continue;
                                }
                                if (!server5.isAvailable()) {
                                    sender.sendMessage("SubServers > Subserver " + server5.getName() + " is not available");
                                    continue;
                                }
                                if (!server5.isEnabled()) {
                                    sender.sendMessage("SubServers > SubServer " + server5.getName() + " is not enabled");
                                    continue;
                                }
                                if (server5.isRunning()) {
                                    ++running;
                                    continue;
                                }
                                if (server5.getCurrentIncompatibilities().size() != 0) {
                                    void var10_77;
                                    String string = "";
                                    List<SubServer> others = server5.getCurrentIncompatibilities();
                                    for (SubServer other : others) {
                                        void var10_80;
                                        if (var10_77.length() != 0) {
                                            String string2 = (String)var10_77 + ", ";
                                        }
                                        String string3 = (String)var10_80 + other.getName();
                                    }
                                    sender.sendMessages(new String[]{"SubServers > Subserver " + server5.getName() + " cannot start while these server" + (others.size() == 1 ? "" : "s") + " are running:", var10_77});
                                    continue;
                                }
                                if (!server5.start()) continue;
                                ++success;
                            }
                            if (running > 0) {
                                sender.sendMessage("SubServers > " + running + " subserver" + (running == 1 ? " was" : "s were") + " already running");
                            }
                            if (success > 0) {
                                sender.sendMessage("SubServers > Started " + success + " subserver" + (success == 1 ? "" : "s"));
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Subservers>");
                    }
                } else if (args[0].equalsIgnoreCase("restart")) {
                    if (args.length > 1) {
                        ServerSelection select = this.selectServers(sender, args, 1, true);
                        if (select.subservers.length > 0) {
                            Consumer<SubServer> starter = server -> {
                                Map<String, Server> servers = this.plugin.api.getServers();
                                if (!servers.containsKey(server.getName().toLowerCase()) || !(servers.get(server.getName().toLowerCase()) instanceof SubServer)) {
                                    sender.sendMessage("SubServers > Could not restart server: Subserver " + server.getName() + " has disappeared");
                                } else if (!(server = (SubServer)servers.get(server.getName().toLowerCase())).isRunning()) {
                                    if (!server.getHost().isAvailable()) {
                                        sender.sendMessage("SubServers > Could not restart server: The host for " + server.getName() + " is no longer available");
                                    } else if (!server.getHost().isEnabled()) {
                                        sender.sendMessage("SubServers > Could not restart server: The host for " + server.getName() + " is no longer enabled");
                                    } else if (!server.isAvailable()) {
                                        sender.sendMessage("SubServers > Could not restart server: Subserver " + server.getName() + " is no longer available");
                                    } else if (!server.isEnabled()) {
                                        sender.sendMessage("SubServers > Could not restart server: Subserver " + server.getName() + " is no longer enabled");
                                    } else if (server.getCurrentIncompatibilities().size() != 0) {
                                        String list = "";
                                        List<SubServer> others = server.getCurrentIncompatibilities();
                                        for (SubServer other : others) {
                                            if (list.length() != 0) {
                                                list = list + ", ";
                                            }
                                            list = list + other.getName();
                                        }
                                        sender.sendMessages(new String[]{"Could not restart server: Subserver " + server.getName() + " cannot start while these server" + (others.size() == 1 ? "" : "s") + " are running:", list});
                                    } else {
                                        server.start();
                                    }
                                }
                            };
                            int success = 0;
                            for (SubServer server6 : select.subservers) {
                                if (server6.isRunning()) {
                                    if (!server6.stop()) continue;
                                    new Thread(() -> {
                                        try {
                                            server6.waitFor();
                                            Thread.sleep(100L);
                                            starter.accept(server6);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }, "SubServers.Bungee::Server_Restart_Command_Handler(" + server6.getName() + ')').start();
                                    ++success;
                                    continue;
                                }
                                starter.accept(server6);
                                ++success;
                            }
                            if (success > 0) {
                                sender.sendMessage("SubServers > Restarting " + success + " subserver" + (success == 1 ? "" : "s"));
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Subservers>");
                    }
                } else if (args[0].equalsIgnoreCase("stop")) {
                    if (args.length > 1) {
                        ServerSelection select = this.selectServers(sender, args, 1, true);
                        if (select.subservers.length > 0) {
                            int success = 0;
                            int running = 0;
                            for (SubServer server7 : select.subservers) {
                                if (!server7.isRunning()) {
                                    ++running;
                                    continue;
                                }
                                if (!server7.stop()) continue;
                                ++success;
                            }
                            if (running > 0) {
                                sender.sendMessage("SubServers > " + running + " subserver" + (running == 1 ? " was" : "s were") + " already offline");
                            }
                            if (success > 0) {
                                sender.sendMessage("SubServers > Stopping " + success + " subserver" + (success == 1 ? "" : "s"));
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Subservers>");
                    }
                } else if (args[0].equalsIgnoreCase("kill") || args[0].equalsIgnoreCase("terminate")) {
                    if (args.length > 1) {
                        ServerSelection select = this.selectServers(sender, args, 1, true);
                        if (select.subservers.length > 0) {
                            int success = 0;
                            int running = 0;
                            for (SubServer server8 : select.subservers) {
                                if (!server8.isRunning()) {
                                    ++running;
                                    continue;
                                }
                                if (!server8.terminate()) continue;
                                ++success;
                            }
                            if (running > 0) {
                                sender.sendMessage("SubServers > " + running + " subserver" + (running == 1 ? " was" : "s were") + " already offline");
                            }
                            if (success > 0) {
                                sender.sendMessage("SubServers > Terminated " + success + " subserver" + (success == 1 ? "" : "s"));
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Subservers>");
                    }
                } else if (args[0].equalsIgnoreCase("cmd") || args[0].equalsIgnoreCase("command")) {
                    if (args.length > 1) {
                        ServerSelection select = this.selectServers(sender, args, 1, false);
                        if (select.servers.length > 0) {
                            if (select.args.length > 2) {
                                void var10_83;
                                StringBuilder builder = new StringBuilder(select.args[2]);
                                for (int i = 3; i < select.args.length; ++i) {
                                    builder.append(' ');
                                    builder.append(select.args[i]);
                                }
                                int success = 0;
                                int running = 0;
                                String string = builder.toString();
                                Server[] getHost = select.servers;
                                int server8 = getHost.length;
                                boolean bl = false;
                                while (var10_83 < server8) {
                                    Server server9 = getHost[var10_83];
                                    if (server9 instanceof SubServer) {
                                        if (!((SubServer)server9).isRunning()) {
                                            ++running;
                                        } else if (server9.command(string)) {
                                            ++success;
                                        }
                                    } else if (server9.getSubData()[0] == null) {
                                        ++running;
                                    } else if (server9.command(string)) {
                                        ++success;
                                    }
                                    ++var10_83;
                                }
                                if (running > 0) {
                                    sender.sendMessage("SubServers > " + running + " server" + (running == 1 ? " was" : "s were") + " unavailable");
                                }
                                if (success > 0) {
                                    sender.sendMessage("SubServers > Sent command to " + success + " server" + (success == 1 ? "" : "s"));
                                }
                            } else {
                                sender.sendMessage("SubServers > No command was entered");
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Servers> <Command> [Args...]");
                    }
                } else if (args[0].equalsIgnoreCase("sudo") || args[0].equalsIgnoreCase("screen")) {
                    if (this.plugin.canSudo) {
                        if (args.length > 1) {
                            Map<String, Server> servers = this.plugin.api.getServers();
                            if (!servers.containsKey(args[1].toLowerCase()) || !(servers.get(args[1].toLowerCase()) instanceof SubServer)) {
                                sender.sendMessage("SubServers > There is no subserver with that name");
                            } else if (!((SubServer)servers.get(args[1].toLowerCase())).isRunning()) {
                                sender.sendMessage("SubServers > That subserver is not running");
                            } else {
                                this.plugin.sudo = (SubServer)servers.get(args[1].toLowerCase());
                                Logger.get((String)"SubServers").info("Now forwarding commands to " + this.plugin.sudo.getDisplayName() + ". Type \"exit\" to return.");
                            }
                        } else {
                            sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Subserver>");
                        }
                    } else {
                        sender.sendMessage("SubServers > The BungeeCord library provided does not support console sudo.");
                    }
                } else if (args[0].equalsIgnoreCase("create")) {
                    if (args.length > 3) {
                        if (this.plugin.api.getSubServers().containsKey(args[1].toLowerCase()) || SubCreator.isReserved(args[1])) {
                            sender.sendMessage("SubServers > There is already a subserver with that name");
                        } else if (!this.plugin.hosts.containsKey(args[2].toLowerCase())) {
                            sender.sendMessage("SubServers > There is no host with that name");
                        } else if (!this.plugin.hosts.get(args[2].toLowerCase()).isAvailable()) {
                            sender.sendMessage("SubServers > That host is not available");
                        } else if (!this.plugin.hosts.get(args[2].toLowerCase()).isEnabled()) {
                            sender.sendMessage("SubServers > That host is not enabled");
                        } else if (!this.plugin.hosts.get(args[2].toLowerCase()).getCreator().getTemplates().containsKey(args[3].toLowerCase())) {
                            sender.sendMessage("SubServers > There is no template with that name");
                        } else if (!this.plugin.hosts.get(args[2].toLowerCase()).getCreator().getTemplate(args[3].toLowerCase()).isEnabled()) {
                            sender.sendMessage("SubServers > That template is not enabled");
                        } else if (args.length <= 4 && this.plugin.hosts.get(args[2].toLowerCase()).getCreator().getTemplate(args[3].toLowerCase()).requiresVersion()) {
                            sender.sendMessage("SubServers > That template requires a Minecraft version to be specified");
                        } else if (!(args.length <= 5 || Try.all.run(() -> Integer.parseInt(args[5])) && Integer.parseInt(args[5]) > 0 && Integer.parseInt(args[5]) <= 65535)) {
                            sender.sendMessage("SubServers > Invalid port number");
                        } else {
                            this.plugin.hosts.get(args[2].toLowerCase()).getCreator().create(args[1], this.plugin.hosts.get(args[2].toLowerCase()).getCreator().getTemplate(args[3].toLowerCase()), args.length > 4 ? new Version(args[4]) : null, args.length > 5 ? Integer.valueOf(Integer.parseInt(args[5])) : null);
                            sender.sendMessage("SubServers > Creating subserver " + args[1]);
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Name> <Host> <Template> [Version] [Port]");
                    }
                } else if (args[0].equalsIgnoreCase("update") || args[0].equalsIgnoreCase("upgrade")) {
                    if (args.length > 1) {
                        ServerSelection select = this.selectServers(sender, args, 1, true);
                        if (select.subservers.length > 0) {
                            String template;
                            String string = template = select.args.length > 3 ? select.args[2].toLowerCase() : null;
                            Version version = select.args.length > 2 ? new Version(select.args[template == null ? 2 : 3]) : null;
                            int success = 0;
                            for (SubServer subServer : select.subservers) {
                                boolean ts;
                                if (!subServer.isAvailable()) {
                                    sender.sendMessage("SubServers > The host for " + subServer.getName() + " is not available");
                                    continue;
                                }
                                if (!subServer.getHost().isEnabled()) {
                                    sender.sendMessage("SubServers > The host for " + subServer.getName() + " is not enabled");
                                    continue;
                                }
                                if (!subServer.isAvailable()) {
                                    sender.sendMessage("SubServers > Subserver " + subServer.getName() + " is not available");
                                    continue;
                                }
                                if (subServer.isRunning()) {
                                    sender.sendMessage("SubServers > Cannot update " + subServer.getName() + " while it is still running");
                                    continue;
                                }
                                SubCreator.ServerTemplate ft = template != null ? subServer.getHost().getCreator().getTemplate(template) : subServer.getTemplate();
                                boolean bl = ts = template == null;
                                if (ft == null) {
                                    if (ts) {
                                        sender.sendMessage("SubServers > We don't know which template built " + subServer.getName());
                                        continue;
                                    }
                                    sender.sendMessage("SubServers > There is no template with that name");
                                    continue;
                                }
                                if (!ft.isEnabled()) {
                                    if (ts) {
                                        sender.sendMessage("SubServers > The template that created " + subServer.getName() + " is not enabled");
                                        continue;
                                    }
                                    sender.sendMessage("SubServers > That template is not enabled");
                                    continue;
                                }
                                if (!ft.canUpdate()) {
                                    if (ts) {
                                        sender.sendMessage("SubServers > The template that created " + subServer.getName() + " does not support subserver updating");
                                        continue;
                                    }
                                    sender.sendMessage("SubServers > That template does not support subserver updating");
                                    continue;
                                }
                                if (version == null && ft.requiresVersion()) {
                                    sender.sendMessage("SubServers > The template that created " + subServer.getName() + " requires a Minecraft version to be specified");
                                    continue;
                                }
                                if (!subServer.getHost().getCreator().update(subServer, ft, version)) continue;
                                ++success;
                            }
                            if (success > 0) {
                                sender.sendMessage("SubServers > Updating " + success + " subserver" + (success == 1 ? "" : "s"));
                            }
                        }
                    } else {
                        sender.sendMessage("SubServers > Usage: " + this.label + " " + args[0].toLowerCase() + " <Subservers> [[Template] <Version>]");
                    }
                } else if (args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("del") || args[0].equalsIgnoreCase("delete")) {
                    ServerSelection select;
                    if (args.length > 1 && (select = this.selectServers(sender, args, 1, true)).subservers.length > 0) {
                        void var7_54;
                        int success = 0;
                        SubServer[] subServerArray = select.subservers;
                        int n = subServerArray.length;
                        boolean bl = false;
                        while (var7_54 < n) {
                            SubServer server11 = subServerArray[var7_54];
                            try {
                                if (server11.isRunning()) {
                                    sender.sendMessage("SubServers > Cannot delete " + server11.getName() + " while it is still running");
                                } else if (server11.getHost().recycleSubServer(server11.getName())) {
                                    ++success;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ++var7_54;
                        }
                        if (success > 0) {
                            sender.sendMessage("SubServers > Removing " + success + " subserver" + (success == 1 ? "" : "s"));
                        }
                    }
                } else if (!args[0].equalsIgnoreCase("restore")) {
                    sender.sendMessage("SubServers > Unknown sub-command: " + args[0]);
                }
            } else {
                sender.sendMessages(this.printHelp());
            }
        } else {
            ProxiedPlayer player = (ProxiedPlayer)sender;
            if (player.getPendingConnection().getVersion() < 759) {
                player.chat(args.length == 0 ? this.label : this.label + ' ' + String.join((CharSequence)" ", args));
            } else {
                player.getServer().sendData("subservers:input", (args.length == 0 ? this.label : this.label + ' ' + String.join((CharSequence)" ", args)).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private ServerSelection selectServers(CommandSender sender, String[] rargs, int index, boolean mode) {
        int i;
        LinkedList<String> msgs = new LinkedList<String>();
        LinkedList<String> args = new LinkedList<String>();
        LinkedList<String> selection = new LinkedList<String>();
        LinkedList<Server> servers = new LinkedList<Server>();
        String last = null;
        for (i = 0; i < index; ++i) {
            args.add(rargs[i]);
        }
        Map<String, Host> hostMap = null;
        Map<String, List<Server>> groupMap = null;
        Map<String, Server> serverMap = null;
        StringBuilder completed = new StringBuilder();
        boolean run = true;
        while (run && i < rargs.length) {
            last = rargs[i];
            Object current = last;
            completed.append((String)current);
            if (((String)current).endsWith(",")) {
                current = ((String)current).substring(0, ((String)current).length() - 1);
                completed.append(' ');
            } else {
                run = false;
            }
            selection.add(((String)current).toLowerCase());
            if (((String)current).length() > 0) {
                LinkedList<Server> select = new LinkedList<Server>();
                if (((String)current).startsWith("::") && ((String)current).length() > 2) {
                    current = ((String)current).substring(2);
                    if (hostMap == null) {
                        hostMap = this.plugin.api.getHosts();
                    }
                    if (((String)current).equals("*")) {
                        for (Host host : hostMap.values()) {
                            select.addAll(host.getSubServers().values());
                        }
                    } else {
                        Host host = hostMap.getOrDefault(((String)current).toLowerCase(), null);
                        if (host != null) {
                            select.addAll(host.getSubServers().values());
                            if (select.size() <= 0) {
                                String string = "SubServers > There are no " + (mode ? "sub" : "") + "servers on host: " + host.getName();
                                if (sender != null) {
                                    sender.sendMessage(string);
                                }
                                msgs.add(string);
                            }
                        } else {
                            String string = "SubServers > There is no host with name: " + (String)current;
                            if (sender != null) {
                                sender.sendMessage(string);
                            }
                            msgs.add(string);
                        }
                    }
                } else if (((String)current).startsWith(":") && ((String)current).length() > 1) {
                    current = ((String)current).substring(1);
                    if (groupMap == null) {
                        groupMap = this.plugin.api.getGroups();
                    }
                    if (((String)current).equals("*")) {
                        for (List list : groupMap.values()) {
                            for (Server server : list) {
                                if (mode && !(server instanceof SubServer)) continue;
                                select.add(server);
                            }
                        }
                    } else {
                        Object group2 = null;
                        for (Map.Entry<String, List<Server>> entry : groupMap.entrySet()) {
                            if (!((String)current).equalsIgnoreCase(entry.getKey())) continue;
                            group2 = entry;
                            break;
                        }
                        if (group2 != null) {
                            for (Server server : (List)group2.getValue()) {
                                if (mode && !(server instanceof SubServer)) continue;
                                select.add(server);
                            }
                            if (select.size() <= 0) {
                                String string = "SubServers > There are no " + (mode ? "sub" : "") + "servers in group: " + (String)group2.getKey();
                                if (sender != null) {
                                    sender.sendMessage(string);
                                }
                                msgs.add(string);
                            }
                        } else {
                            String string = "SubServers > There is no group with name: " + (String)current;
                            if (sender != null) {
                                sender.sendMessage(string);
                            }
                            msgs.add(string);
                        }
                    }
                } else {
                    if (serverMap == null) {
                        serverMap = this.plugin.api.getServers();
                    }
                    if (((String)current).equals("*")) {
                        for (Server server : serverMap.values()) {
                            if (mode && !(server instanceof SubServer)) continue;
                            select.add(server);
                        }
                    } else {
                        Server server = serverMap.getOrDefault(((String)current).toLowerCase(), null);
                        if (server != null) {
                            select.add(server);
                        } else {
                            String string = "SubServers > There is no " + (mode ? "sub" : "") + "server with name: " + (String)current;
                            if (sender != null) {
                                sender.sendMessage(string);
                            }
                            msgs.add(string);
                        }
                    }
                }
                for (Server server : select) {
                    if (servers.contains(server)) continue;
                    servers.add(server);
                }
            }
            ++i;
        }
        args.add(completed.toString());
        while (i < rargs.length) {
            args.add(rargs[i]);
            last = null;
            ++i;
        }
        LinkedList<SubServer> subservers = new LinkedList<SubServer>();
        for (Server server : servers) {
            if (!(server instanceof SubServer)) continue;
            subservers.add((SubServer)server);
        }
        if (!mode && servers.size() <= 0 || mode && subservers.size() <= 0) {
            String msg = "SubServers > No " + (mode ? "sub" : "") + "servers were selected";
            if (sender != null) {
                sender.sendMessage(msg);
            }
            msgs.add(msg);
        }
        return new ServerSelection(msgs, selection, servers, subservers, args, last);
    }

    private String[] printHelp() {
        return new String[]{"SubServers > Console Command Help:", "   Help: /sub help", "   List: /sub list", "   Version: /sub version", "   Reload: /sub reload [hard|bungee|servers|templates]", "   Info: /sub info [proxy|host|group|server|player] <Name>", "   Start Server: /sub start <Subservers>", "   Restart Server: /sub restart <Subservers>", "   Stop Server: /sub stop <Subservers>", "   Terminate Server: /sub kill <Subservers>", "   Command Server: /sub cmd <Servers> <Command> [Args...]", "   Sudo Server: /sub sudo <Subserver>", "   Create Server: /sub create <Name> <Host> <Template> [Version] [Port]", "   Update Server: /sub update <Subservers> [[Template] <Version>]", "   Remove Server: /sub delete <Subservers>", "", "   To see BungeeCord supplied commands, please visit:", "   https://www.spigotmc.org/wiki/bungeecord-commands/"};
    }

    /*
     * WARNING - void declaration
     */
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        String Last = args.length > 0 ? args[args.length - 1] : "";
        String last = Last.toLowerCase();
        if (!(!(sender instanceof ProxiedPlayer) || players.containsKey(((ProxiedPlayer)sender).getUniqueId()) && players.get(((ProxiedPlayer)sender).getUniqueId()).containsKey(((ProxiedPlayer)sender).getServer().getInfo()) && ((Boolean)players.get(((ProxiedPlayer)sender).getUniqueId()).get(((ProxiedPlayer)sender).getServer().getInfo()).value()).booleanValue())) {
            if (!(players.containsKey(((ProxiedPlayer)sender).getUniqueId()) && players.get(((ProxiedPlayer)sender).getUniqueId()).containsKey(((ProxiedPlayer)sender).getServer().getInfo()) && players.get(((ProxiedPlayer)sender).getUniqueId()).get(((ProxiedPlayer)sender).getServer().getInfo()).key() == null || players.containsKey(((ProxiedPlayer)sender).getUniqueId()) && players.get(((ProxiedPlayer)sender).getUniqueId()).containsKey(((ProxiedPlayer)sender).getServer().getInfo()) && Calendar.getInstance().getTime().getTime() - (Long)players.get(((ProxiedPlayer)sender).getUniqueId()).get(((ProxiedPlayer)sender).getServer().getInfo()).key() < TimeUnit.MINUTES.toMillis(1L))) {
                if (!(((ProxiedPlayer)sender).getServer().getInfo() instanceof Server) || ((Server)((ProxiedPlayer)sender).getServer().getInfo()).getSubData()[0] == null) {
                    HashMap<ServerInfo, ContainedPair> map = players.containsKey(((ProxiedPlayer)sender).getUniqueId()) ? players.get(((ProxiedPlayer)sender).getUniqueId()) : new HashMap<ServerInfo, ContainedPair>();
                    map.put(((ProxiedPlayer)sender).getServer().getInfo(), new ContainedPair((Object)Calendar.getInstance().getTime().getTime(), (Object)false));
                    players.put(((ProxiedPlayer)sender).getUniqueId(), map);
                } else {
                    HashMap<ServerInfo, ContainedPair> map = players.containsKey(((ProxiedPlayer)sender).getUniqueId()) ? players.get(((ProxiedPlayer)sender).getUniqueId()) : new HashMap<ServerInfo, ContainedPair>();
                    map.put(((ProxiedPlayer)sender).getServer().getInfo(), new ContainedPair(null, (Object)false));
                    players.put(((ProxiedPlayer)sender).getUniqueId(), map);
                    ((SubDataClient)((Server)((ProxiedPlayer)sender).getServer().getInfo()).getSubData()[0]).sendPacket(new PacketOut[]{new PacketCheckPermission(((ProxiedPlayer)sender).getUniqueId(), "subservers.command", result -> map.put(((ProxiedPlayer)sender).getServer().getInfo(), new ContainedPair((Object)Calendar.getInstance().getTime().getTime(), result)))});
                }
            }
            return Collections.emptyList();
        }
        if (args.length <= 1) {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.addAll(Arrays.asList("help", "list", "info", "status", "version", "start", "restart", "stop", "kill", "terminate", "cmd", "command", "create", "update", "upgrade", "restore"));
            if (!(sender instanceof ProxiedPlayer)) {
                cmds.addAll(Arrays.asList("reload", "sudo", "screen", "remove", "delete"));
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String string : cmds) {
                if (!string.startsWith(last)) continue;
                list.add(Last + string.substring(last.length()));
            }
            return list;
        }
        if (args[0].equals("info") || args[0].equals("status")) {
            Supplier<Collection> getPlayers = () -> {
                LinkedList<String> names = new LinkedList<String>();
                for (ProxiedPlayer proxiedPlayer : this.plugin.getPlayers()) {
                    names.add(proxiedPlayer.getName());
                }
                for (RemotePlayer remotePlayer : this.plugin.api.getRemotePlayers().values()) {
                    if (names.contains(remotePlayer.getName())) continue;
                    names.add(remotePlayer.getName());
                }
                Collections.sort(names);
                return names;
            };
            if (args.length == 2) {
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> subcommands = new ArrayList<String>();
                subcommands.add("proxy");
                subcommands.add("host");
                subcommands.add("group");
                subcommands.add("server");
                subcommands.add("subserver");
                subcommands.add("player");
                for (String string : subcommands) {
                    if (list.contains(string) || !string.toLowerCase().startsWith(last)) continue;
                    list.add(Last + string.substring(last.length()));
                }
                Proxy proxy = this.plugin.api.getMasterProxy();
                if (proxy != null && !list.contains(proxy.getName()) && proxy.getName().toLowerCase().startsWith(last)) {
                    list.add(Last + proxy.getName().substring(last.length()));
                }
                for (Proxy proxy2 : this.plugin.api.getProxies().values()) {
                    if (list.contains(proxy2.getName()) || !proxy2.getName().toLowerCase().startsWith(last)) continue;
                    list.add(Last + proxy2.getName().substring(last.length()));
                }
                for (Host host : this.plugin.api.getHosts().values()) {
                    if (list.contains(host.getName()) || !host.getName().toLowerCase().startsWith(last)) continue;
                    list.add(Last + host.getName().substring(last.length()));
                }
                for (String group : this.plugin.api.getGroups().keySet()) {
                    if (list.contains(group) || !group.toLowerCase().startsWith(last)) continue;
                    list.add(Last + group.substring(last.length()));
                }
                for (Server server : this.plugin.api.getServers().values()) {
                    if (list.contains(server.getName()) || !server.getName().toLowerCase().startsWith(last)) continue;
                    list.add(Last + server.getName().substring(last.length()));
                }
                for (String player : getPlayers.get()) {
                    if (list.contains(player) || !player.toLowerCase().startsWith(last)) continue;
                    list.add(Last + player.substring(last.length()));
                }
                return list;
            }
            if (args.length == 3) {
                void var8_46;
                ArrayList<String> list = new ArrayList<String>();
                String subcommands = args[1].toLowerCase();
                int n = -1;
                switch (subcommands.hashCode()) {
                    case 112: {
                        if (!subcommands.equals("p")) break;
                        boolean bl = false;
                        break;
                    }
                    case 106941038: {
                        if (!subcommands.equals("proxy")) break;
                        boolean bl = true;
                        break;
                    }
                    case 104: {
                        if (!subcommands.equals("h")) break;
                        int n2 = 2;
                        break;
                    }
                    case 3208616: {
                        if (!subcommands.equals("host")) break;
                        int n3 = 3;
                        break;
                    }
                    case 103: {
                        if (!subcommands.equals("g")) break;
                        int n4 = 4;
                        break;
                    }
                    case 98629247: {
                        if (!subcommands.equals("group")) break;
                        int n5 = 5;
                        break;
                    }
                    case 115: {
                        if (!subcommands.equals("s")) break;
                        int n6 = 6;
                        break;
                    }
                    case -905826493: {
                        if (!subcommands.equals("server")) break;
                        int n7 = 7;
                        break;
                    }
                    case 516701571: {
                        if (!subcommands.equals("subserver")) break;
                        int n8 = 8;
                        break;
                    }
                    case 117: {
                        if (!subcommands.equals("u")) break;
                        int n9 = 9;
                        break;
                    }
                    case 3599307: {
                        if (!subcommands.equals("user")) break;
                        int n10 = 10;
                        break;
                    }
                    case -985752863: {
                        if (!subcommands.equals("player")) break;
                        int n11 = 11;
                    }
                }
                switch (var8_46) {
                    case 0: 
                    case 1: {
                        Proxy proxy = this.plugin.api.getMasterProxy();
                        if (proxy != null && proxy.getName().toLowerCase().startsWith(last)) {
                            list.add(Last + proxy.getName().substring(last.length()));
                        }
                        for (Proxy proxy3 : this.plugin.api.getProxies().values()) {
                            if (list.contains(proxy3.getName()) || !proxy3.getName().toLowerCase().startsWith(last)) continue;
                            list.add(Last + proxy3.getName().substring(last.length()));
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        for (Host host : this.plugin.api.getHosts().values()) {
                            if (!host.getName().toLowerCase().startsWith(last)) continue;
                            list.add(Last + host.getName().substring(last.length()));
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        for (String group : this.plugin.api.getGroups().keySet()) {
                            if (!group.toLowerCase().startsWith(last)) continue;
                            list.add(Last + group.substring(last.length()));
                        }
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        for (Server server : this.plugin.api.getServers().values()) {
                            if (args[1].equalsIgnoreCase("subserver") && !(server instanceof SubServer) || !server.getName().toLowerCase().startsWith(last)) continue;
                            list.add(Last + server.getName().substring(last.length()));
                        }
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        for (String player : getPlayers.get()) {
                            if (!player.toLowerCase().startsWith(last)) continue;
                            list.add(Last + player.substring(last.length()));
                        }
                        break;
                    }
                }
                return list;
            }
            return Collections.emptyList();
        }
        if (!(sender instanceof ProxiedPlayer) && (args[0].equals("reload") || args[0].equals("restore"))) {
            if (args[0].equals("reload")) {
                ArrayList<String> list = new ArrayList<String>();
                List<String> completes = Arrays.asList("hard", "bungee", "servers", "templates");
                if (args.length == 2) {
                    for (String string : completes) {
                        if (!string.toLowerCase().startsWith(last)) continue;
                        list.add(Last + string.substring(last.length()));
                    }
                    return list;
                }
                return Collections.emptyList();
            }
            if (args.length == 2) {
                return Collections.singletonList("<Subserver>");
            }
            return Collections.emptyList();
        }
        if (args[0].equals("start") || args[0].equals("restart") || args[0].equals("stop") || args[0].equals("kill") || args[0].equals("terminate") || args[0].equals("cmd") || args[0].equals("command") || args[0].equals("update") || args[0].equals("upgrade") || args[0].equals("remove") || args[0].equals("del") || args[0].equals("delete") || !(sender instanceof ProxiedPlayer) && (args[0].equals("sudo") || args[0].equals("screen"))) {
            ArrayList<String> list = new ArrayList<String>();
            boolean mode = !args[0].equals("cmd") && !args[0].equals("command");
            ServerSelection select = this.selectServers(null, args, 1, mode);
            if (select.last != null) {
                Map<String, Server> map;
                if (last.startsWith("::")) {
                    Map<String, Host> map2 = this.plugin.api.getHosts();
                    if (map2.size() > 0) {
                        if (Arrays.binarySearch(select.selection, "::*") < 0 && "::*".startsWith(last)) {
                            list.add("::*");
                        }
                        if (sender instanceof ProxiedPlayer && Arrays.binarySearch(select.selection, "::.") < 0 && "::.".startsWith(last)) {
                            list.add("::.");
                        }
                        for (Host host : map2.values()) {
                            String name = "::" + host.getName();
                            if (Arrays.binarySearch(select.selection, name.toLowerCase()) >= 0 || !name.toLowerCase().startsWith(last)) continue;
                            list.add(Last + name.substring(last.length()));
                        }
                    }
                    return list;
                }
                if (last.startsWith(":")) {
                    Map<String, List<Server>> map3 = this.plugin.api.getGroups();
                    if (map3.size() > 0) {
                        if (Arrays.binarySearch(select.selection, ":*") < 0 && ":*".startsWith(last)) {
                            list.add(":*");
                        }
                        if (sender instanceof ProxiedPlayer && Arrays.binarySearch(select.selection, ":.") < 0 && ":.".startsWith(last)) {
                            list.add(":.");
                        }
                        for (String group : map3.keySet()) {
                            group = ":" + group;
                            if (Arrays.binarySearch(select.selection, group.toLowerCase()) >= 0 || !group.toLowerCase().startsWith(last)) continue;
                            list.add(Last + group.substring(last.length()));
                        }
                    }
                    return list;
                }
                Map<String, Server> map4 = map = mode ? this.plugin.api.getSubServers() : this.plugin.api.getServers();
                if (map.size() > 0) {
                    if (Arrays.binarySearch(select.selection, "*") < 0 && "*".startsWith(last)) {
                        list.add("*");
                    }
                    if (sender instanceof ProxiedPlayer && Arrays.binarySearch(select.selection, ".") < 0 && ".".startsWith(last)) {
                        list.add(".");
                    }
                    for (Server server : map.values()) {
                        if (Arrays.binarySearch(select.selection, server.getName().toLowerCase()) >= 0 || !server.getName().toLowerCase().startsWith(last)) continue;
                        list.add(Last + server.getName().substring(last.length()));
                    }
                }
                return list;
            }
            if (args[0].equals("cmd") || args[0].equals("command")) {
                if (select.args.length == 3) {
                    return Collections.singletonList("<Command>");
                }
                return Collections.singletonList("[Args...]");
            }
            if (args[0].equals("update") || args[0].equals("upgrade")) {
                if (select.args.length == 3) {
                    return Arrays.asList("[Template]", "[Version]");
                }
                if (select.args.length == 4) {
                    return Collections.singletonList("<Version>");
                }
            }
            return Collections.emptyList();
        }
        if (args[0].equals("create")) {
            if (args.length == 2) {
                return Collections.singletonList("<Name>");
            }
            if (args.length == 3) {
                ArrayList<String> list = new ArrayList<String>();
                for (Host host : this.plugin.api.getHosts().values()) {
                    if (!host.getName().toLowerCase().startsWith(last)) continue;
                    list.add(Last + host.getName().substring(last.length()));
                }
                return list;
            }
            if (args.length == 4) {
                ArrayList<String> list = new ArrayList<String>();
                Map<String, Host> hosts = this.plugin.api.getHosts();
                if (!hosts.containsKey(args[2].toLowerCase())) {
                    list.add("<Template>");
                } else {
                    for (SubCreator.ServerTemplate serverTemplate : hosts.get(args[2].toLowerCase()).getCreator().getTemplates().values()) {
                        if (!serverTemplate.getName().toLowerCase().startsWith(last)) continue;
                        list.add(Last + serverTemplate.getName().substring(last.length()));
                    }
                }
                return list;
            }
            if (args.length == 5) {
                return Collections.singletonList("[Version]");
            }
            if (args.length == 6) {
                if (!(last.length() <= 0 || Try.all.run(() -> Integer.parseInt(last)) && Integer.parseInt(last) > 0 && Integer.parseInt(last) <= 65535)) {
                    return Collections.emptyList();
                }
                return Collections.singletonList("[Port]");
            }
            return Collections.emptyList();
        }
        if (args[0].equals("restore")) {
            if (args.length == 2) {
                return Collections.singletonList("<Subserver>");
            }
            return Collections.emptyList();
        }
        if (sender instanceof ProxiedPlayer && (args[0].equals("tp") || args[0].equals("teleport"))) {
            if (args.length == 2 || args.length == 3) {
                ArrayList<String> list = new ArrayList<String>();
                if (args.length == 2) {
                    list.add("@p");
                    list.add("@a");
                    list.add("@r");
                    list.add("@s");
                    ArrayList<UUID> used = new ArrayList<UUID>();
                    for (ProxiedPlayer proxiedPlayer : ((ProxiedPlayer)sender).getServer().getInfo().getPlayers()) {
                        if (proxiedPlayer.getName().toLowerCase().startsWith(last)) {
                            list.add(Last + proxiedPlayer.getName().substring(last.length()));
                        }
                        used.add(proxiedPlayer.getUniqueId());
                    }
                    if (((ProxiedPlayer)sender).getServer().getInfo() instanceof Server) {
                        for (RemotePlayer remotePlayer : ((Server)((ProxiedPlayer)sender).getServer().getInfo()).getRemotePlayers()) {
                            if (used.contains(remotePlayer.getUniqueId())) continue;
                            if (remotePlayer.getName().toLowerCase().startsWith(last)) {
                                list.add(Last + remotePlayer.getName().substring(last.length()));
                            }
                            used.add(remotePlayer.getUniqueId());
                        }
                    }
                }
                for (Server server : this.plugin.api.getServers().values()) {
                    if (!server.getName().toLowerCase().startsWith(last)) continue;
                    list.add(Last + server.getName().substring(last.length()));
                }
                return list;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private static final class ServerSelection {
        private final String[] msgs;
        private final String[] selection;
        private final Server[] servers;
        private final SubServer[] subservers;
        private final String[] args;
        private final String last;

        private ServerSelection(List<String> msgs, List<String> selection, List<Server> servers, List<SubServer> subservers, List<String> args, String last) {
            this.msgs = msgs.toArray(new String[0]);
            this.selection = selection.toArray(new String[0]);
            this.servers = servers.toArray(new Server[0]);
            this.subservers = subservers.toArray(new SubServer[0]);
            this.args = args.toArray(new String[0]);
            this.last = last;
            Arrays.sort(this.selection);
        }
    }

    public static final class BungeeList
    extends Command {
        private SubProxy plugin;

        BungeeList(SubProxy plugin, String command) {
            super(command, "bungeecord.command.list", new String[0]);
            this.plugin = plugin;
        }

        public void execute(CommandSender sender, String[] args) {
            LinkedList<String> messages = new LinkedList<String>();
            int players = 0;
            for (Server server : this.plugin.api.getServers().values()) {
                ArrayList<String> playerlist = new ArrayList<String>();
                for (RemotePlayer player : server.getRemotePlayers()) {
                    playerlist.add(player.getName());
                }
                Collections.sort(playerlist);
                players += playerlist.size();
                if (server.isHidden() || server instanceof SubServer && !((SubServer)server).isRunning()) continue;
                int i = 0;
                String message = this.plugin.api.getLang("SubServers", "Bungee.List.Format").replace("$str$", server.getDisplayName()).replace("$int$", Integer.toString(playerlist.size()));
                for (String player : playerlist) {
                    if (i != 0) {
                        message = message + this.plugin.api.getLang("SubServers", "Bungee.List.Divider");
                    }
                    message = message + this.plugin.api.getLang("SubServers", "Bungee.List.List").replace("$str$", player);
                    ++i;
                }
                messages.add(message);
            }
            sender.sendMessages(messages.toArray(new String[messages.size()]));
            sender.sendMessage(this.plugin.api.getLang("SubServers", "Bungee.List.Total").replace("$int$", Integer.toString(players)));
        }
    }

    public static final class BungeeServer
    extends Command
    implements TabExecutor {
        private SubProxy plugin;

        BungeeServer(SubProxy plugin, String command) {
            super(command, "bungeecord.command.server", new String[0]);
            this.plugin = plugin;
        }

        public void execute(CommandSender sender, String[] args) {
            if (sender instanceof ProxiedPlayer) {
                if (args.length > 0) {
                    Map<String, Server> servers = this.plugin.api.getServers();
                    if (servers.containsKey(args[0].toLowerCase())) {
                        ((ProxiedPlayer)sender).connect((ServerInfo)servers.get(args[0].toLowerCase()));
                    } else {
                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Bungee.Server.Invalid"));
                    }
                } else {
                    int i = 0;
                    TextComponent serverm = new TextComponent(ChatColor.RESET.toString());
                    TextComponent div = new TextComponent(this.plugin.api.getLang("SubServers", "Bungee.Server.Divider"));
                    for (Server server : this.plugin.api.getServers().values()) {
                        if (server.isHidden() || !server.canAccess(sender) || server instanceof SubServer && !((SubServer)server).isRunning()) continue;
                        if (i != 0) {
                            serverm.addExtra((BaseComponent)div);
                        }
                        TextComponent message = new TextComponent(this.plugin.api.getLang("SubServers", "Bungee.Server.List").replace("$str$", server.getDisplayName()));
                        try {
                            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent(this.plugin.api.getLang("SubServers", "Bungee.Server.Hover").replace("$int$", Integer.toString(server.getRemotePlayers().size())))}));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/server " + server.getName()));
                        serverm.addExtra((BaseComponent)message);
                        ++i;
                    }
                    sender.sendMessages(new String[]{this.plugin.api.getLang("SubServers", "Bungee.Server.Current").replace("$str$", ((ProxiedPlayer)sender).getServer().getInfo().getName()), this.plugin.api.getLang("SubServers", "Bungee.Server.Available")});
                    sender.sendMessage((BaseComponent)serverm);
                }
            } else {
                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Player-Only"));
            }
        }

        public List<String> onTabComplete(CommandSender sender, String[] args) {
            if (args.length <= 1) {
                String last = args.length > 0 ? args[args.length - 1].toLowerCase() : "";
                ArrayList<String> list = new ArrayList<String>();
                for (Server server : this.plugin.api.getServers().values()) {
                    if (!server.getName().toLowerCase().startsWith(last) || server.isHidden()) continue;
                    list.add(server.getName());
                }
                return list;
            }
            return Collections.emptyList();
        }
    }
}

