/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client.Library;

import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.SubData.Client.Library.PingResponse;
import net.ME1312.SubData.Client.Protocol.MessageOut;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubData.Client.SubDataProtocol;
import net.ME1312.SubData.Client.SubDataSender;

public class ForwardedDataSender
implements SubDataSender {
    private final SubDataClient client;
    private final UUID id;

    public ForwardedDataSender(SubDataClient client, UUID id) {
        this.client = client;
        this.id = id;
    }

    public void ping(Consumer<PingResponse> response) {
        this.client.ping(this.id, response);
    }

    @Override
    public void sendPacket(PacketOut ... packets) {
        try {
            SubDataClient.class.getMethod("forwardPacket", UUID.class, PacketOut[].class).invoke((Object)this.client, this.id, packets);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendMessage(MessageOut ... messages) {
        try {
            SubDataClient.class.getMethod("forwardMessage", UUID.class, MessageOut[].class).invoke((Object)this.client, this.id, messages);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public SubDataClient getConnection() {
        return this.client;
    }

    @Override
    public SubDataProtocol getProtocol() {
        return this.client.getProtocol();
    }

    public UUID getID() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForwardedDataSender) {
            return this.id.equals(((ForwardedDataSender)obj).id);
        }
        return super.equals(obj);
    }
}

