/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client.Library;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class InputStreamL1 {
    private final Runnable shutdown;
    private final Consumer<Integer> error;
    private final InputStream in;
    private Runnable reset;
    private Runnable close;
    private DataInterface open;

    public InputStreamL1(InputStream in, Runnable shutdown, Consumer<Integer> error) {
        this.in = in;
        this.shutdown = shutdown;
        this.error = error;
    }

    public InputStream open(Runnable reset, Runnable close) {
        if (this.open != null) {
            this.open.shutdown();
        }
        this.reset = reset;
        this.close = close;
        this.open = new DataInterface();
        return this.open;
    }

    public void shutdown() {
        if (this.open != null) {
            this.reset.run();
            this.open.shutdown();
        }
    }

    private final class DataInterface
    extends InputStream {
        private int permitted = 0;

        private DataInterface() {
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (InputStreamL1.this.open == this) {
                int total = 0;
                while (true) {
                    int transferred;
                    if ((transferred = InputStreamL1.this.in.read(data, offset, Math.min(length, this.permitted))) == -1) {
                        InputStreamL1.this.shutdown.run();
                        if (total == 0) {
                            return -1;
                        }
                        return total;
                    }
                    total += transferred;
                    this.permitted -= transferred;
                    if (transferred == length || this.permitted != 0) {
                        return total;
                    }
                    if (this.permit()) {
                        if (total == 0) {
                            return -1;
                        }
                        return total;
                    }
                    offset += transferred;
                    length -= transferred;
                }
            }
            return -1;
        }

        @Override
        public int read() throws IOException {
            do {
                if (this.permitted == 0) continue;
                int b = InputStreamL1.this.in.read();
                if (b == -1) {
                    InputStreamL1.this.shutdown.run();
                    return -1;
                }
                --this.permitted;
                return b;
            } while (!this.permit());
            return -1;
        }

        @Override
        public void close() throws IOException {
            while (this.read() != -1) {
            }
        }

        private void shutdown() {
            InputStreamL1.this.open = null;
            this.permitted = 0;
        }

        private boolean permit() throws IOException {
            if (InputStreamL1.this.open == this) {
                int b = InputStreamL1.this.in.read();
                while (true) {
                    switch (b) {
                        case 19: {
                            this.permitted = (InputStreamL1.this.in.read() + 1) * 0x400000;
                            return false;
                        }
                        case 18: {
                            this.permitted = (InputStreamL1.this.in.read() + 1) * 4096;
                            return false;
                        }
                        case 17: {
                            this.permitted = (InputStreamL1.this.in.read() + 1) * 4;
                            return false;
                        }
                        case 16: {
                            this.permitted = 1;
                            return false;
                        }
                        case 24: {
                            InputStreamL1.this.reset.run();
                        }
                        case 23: {
                            this.shutdown();
                            InputStreamL1.this.close.run();
                            return true;
                        }
                        case 0: {
                            break;
                        }
                        case -1: {
                            InputStreamL1.this.shutdown.run();
                            return true;
                        }
                        default: {
                            InputStreamL1.this.error.accept(b);
                            return true;
                        }
                    }
                    b = InputStreamL1.this.in.read();
                }
            }
            return true;
        }
    }
}

