/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client.Library;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.ME1312.SubData.Client.Library.DebugUtil;

public class OutputStreamL1
extends OutputStream {
    private final ExecutorService writer = Executors.newSingleThreadExecutor(r -> new Thread(r, name));
    private final Logger log;
    private final Runnable shutdown;
    private final OutputStream out;
    private byte[] block;
    private int cursor = 0;
    public int limit;

    public OutputStreamL1(Logger log, OutputStream stream, int limit, Runnable shutdown, String name) {
        this.shutdown = shutdown;
        this.log = log;
        this.out = stream;
        this.limit = limit;
        this.block = new byte[limit];
    }

    public void resize(int limit) {
        if (this.limit != limit) {
            this.limit = limit;
            if (this.cursor >= limit) {
                this.flush();
            } else {
                byte[] block = this.block;
                this.block = new byte[limit];
                System.arraycopy(block, 0, this.block, 0, this.cursor);
            }
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        while (true) {
            int transferred = Math.min(length, this.block.length - this.cursor);
            System.arraycopy(data, offset, this.block, this.cursor, transferred);
            this.cursor += transferred;
            if (transferred == length) {
                if (this.cursor == this.block.length) {
                    this.flush();
                }
                return;
            }
            this.flush();
            offset += transferred;
            length -= transferred;
        }
    }

    @Override
    public void write(int b) {
        this.block[this.cursor++] = (byte)b;
        if (this.cursor == this.block.length) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this.cursor != 0 && !this.writer.isShutdown()) {
            if (this.cursor == this.block.length || this.limit != this.block.length) {
                this.writer.submit(() -> OutputStreamL1.lambda$flush$1(new DataFlusher(this.block, this.cursor)));
                this.block = new byte[this.limit];
            } else {
                byte[] block = new byte[this.cursor];
                System.arraycopy(this.block, 0, block, 0, this.cursor);
                this.writer.submit(() -> OutputStreamL1.lambda$flush$2(new DataFlusher(block, this.cursor)));
            }
            this.cursor = 0;
        }
    }

    public void control(int b) {
        if (!this.writer.isShutdown()) {
            this.writer.submit(() -> {
                try {
                    this.out.write(b);
                    this.out.flush();
                }
                catch (IOException e) {
                    if (!(e instanceof SocketException)) {
                        DebugUtil.logException(e, this.log);
                    }
                    this.shutdown.run();
                }
            });
        }
    }

    public void shutdown() {
        this.writer.shutdown();
    }

    private static /* synthetic */ void lambda$flush$2(DataFlusher rec$) {
        rec$.flush();
    }

    private static /* synthetic */ void lambda$flush$1(DataFlusher rec$) {
        rec$.flush();
    }

    private final class DataFlusher {
        private final byte[] block;
        private int stored;
        private int cursor = 0;

        private DataFlusher(byte[] data, int length) {
            this.stored = length;
            this.block = data;
        }

        private void flush() {
            try {
                while (this.stored > 0) {
                    if (this.stored >= 0x400000) {
                        this.stored -= this.flushMBB();
                        continue;
                    }
                    if (this.stored >= 4096) {
                        this.stored -= this.flushKBB();
                        continue;
                    }
                    if (this.stored >= 4) {
                        this.stored -= this.flushBB();
                        continue;
                    }
                    this.stored -= this.flushByte();
                }
            }
            catch (IOException e) {
                if (!(e instanceof SocketException)) {
                    DebugUtil.logException(e, OutputStreamL1.this.log);
                }
                OutputStreamL1.this.shutdown.run();
            }
        }

        private int flushMBB() throws IOException {
            int size = Math.min(this.stored / 0x400000, 256);
            int length = size * 0x400000;
            OutputStreamL1.this.out.write(19);
            OutputStreamL1.this.out.write((byte)(size - 1));
            OutputStreamL1.this.out.write(this.block, this.cursor, length);
            this.cursor += length;
            return length;
        }

        private int flushKBB() throws IOException {
            int size = Math.min(this.stored / 4096, 256);
            int length = size * 4096;
            OutputStreamL1.this.out.write(18);
            OutputStreamL1.this.out.write((byte)(size - 1));
            OutputStreamL1.this.out.write(this.block, this.cursor, length);
            this.cursor += length;
            return length;
        }

        private int flushBB() throws IOException {
            int size = Math.min(this.stored / 4, 256);
            int length = size * 4;
            OutputStreamL1.this.out.write(17);
            OutputStreamL1.this.out.write((byte)(size - 1));
            OutputStreamL1.this.out.write(this.block, this.cursor, length);
            this.cursor += length;
            return length;
        }

        private int flushByte() throws IOException {
            OutputStreamL1.this.out.write(16);
            OutputStreamL1.this.out.write(this.block[this.cursor++]);
            return 1;
        }
    }
}

