/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client.Protocol.Internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.Library.ForwardedDataSender;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.Protocol.PacketStreamIn;
import net.ME1312.SubData.Client.Protocol.PacketStreamOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketForwardPacket
implements PacketStreamIn,
PacketStreamOut {
    private final PacketOut packet;
    private final UUID id;

    public PacketForwardPacket(UUID id, PacketOut packet) {
        this.id = id;
        this.packet = packet;
    }

    @Override
    public void send(SubDataSender sender, OutputStream data) throws Throwable {
        data.write(ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN).putLong(this.id.getMostSignificantBits()).putLong(this.id.getLeastSignificantBits()).array());
        Util.reflect((Method)SubDataClient.class.getDeclaredMethod("write", SubDataSender.class, PacketOut.class, OutputStream.class), (Object)sender.getConnection(), (Object[])new Object[]{new ForwardedDataSender(sender.getConnection(), this.id), this.packet, data});
    }

    @Override
    public void receive(SubDataSender sender, InputStream in) throws Throwable {
        int b;
        ByteBuffer data = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        int i = 0;
        while ((b = in.read()) != -1) {
            data.put((byte)b);
            if (++i != 16) continue;
        }
        data.position(0);
        if (i != 16) {
            throw new IllegalArgumentException("Invalid UUID data for Sender ID: [" + data.getLong() + ", " + data.getLong() + "]");
        }
        Util.reflect((Method)SubDataClient.class.getDeclaredMethod("read", SubDataSender.class, Container.class, InputStream.class), (Object)sender.getConnection(), (Object[])new Object[]{new ForwardedDataSender(sender.getConnection(), new UUID(data.getLong(), data.getLong())), new Container((Object)false), in});
    }
}

