/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client.Protocol.Internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.Library.PingResponse;
import net.ME1312.SubData.Client.Protocol.Forwardable;
import net.ME1312.SubData.Client.Protocol.Internal.PacketPingResponse;
import net.ME1312.SubData.Client.Protocol.PacketStreamIn;
import net.ME1312.SubData.Client.Protocol.PacketStreamOut;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketPing
implements Forwardable,
PacketStreamOut,
PacketStreamIn {
    static HashMap<UUID, PacketPing> requests = new HashMap();
    Consumer<PingResponse>[] callbacks;
    private UUID tracker;
    long init;
    long queue;

    public PacketPing() {
    }

    @SafeVarargs
    public PacketPing(Consumer<PingResponse> ... callback) {
        Util.nullpo(callback);
        this.tracker = (UUID)Util.getNew(requests.keySet(), UUID::randomUUID);
        requests.put(this.tracker, this);
        this.callbacks = callback;
        this.init = System.nanoTime();
    }

    @Override
    public void send(SubDataSender sender, OutputStream out) throws Throwable {
        this.queue = System.nanoTime();
        out.write(ByteBuffer.allocate(32).order(ByteOrder.BIG_ENDIAN).putLong(this.tracker.getMostSignificantBits()).putLong(this.tracker.getLeastSignificantBits()).putLong(this.init).putLong(this.queue).array());
        out.close();
    }

    @Override
    public void receive(SubDataSender sender, InputStream in) throws Throwable {
        int b;
        ByteBuffer data = ByteBuffer.allocate(32).order(ByteOrder.BIG_ENDIAN);
        int i = 0;
        while ((b = in.read()) != -1) {
            data.put((byte)b);
            if (++i != 32) continue;
        }
        in.close();
        data.position(0);
        UUID request = new UUID(data.getLong(), data.getLong());
        data.getLong();
        data.getLong();
        sender.sendPacket(new PacketPingResponse(request, System.nanoTime()));
    }
}

