/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.Cipher;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.Encryption.NEH;
import net.ME1312.SubData.Client.Library.ConnectionState;
import net.ME1312.SubData.Client.Library.DebugUtil;
import net.ME1312.SubData.Client.Library.DisconnectReason;
import net.ME1312.SubData.Client.Library.Exception.EncryptionException;
import net.ME1312.SubData.Client.Library.Exception.IllegalMessageException;
import net.ME1312.SubData.Client.Library.Exception.IllegalPacketException;
import net.ME1312.SubData.Client.Library.Exception.IllegalSenderException;
import net.ME1312.SubData.Client.Library.Exception.ProtocolException;
import net.ME1312.SubData.Client.Library.ForwardedDataSender;
import net.ME1312.SubData.Client.Library.InputStreamL1;
import net.ME1312.SubData.Client.Library.OutputStreamL1;
import net.ME1312.SubData.Client.Library.PingResponse;
import net.ME1312.SubData.Client.Library.UnsignedData;
import net.ME1312.SubData.Client.Protocol.ForwardOnly;
import net.ME1312.SubData.Client.Protocol.Forwardable;
import net.ME1312.SubData.Client.Protocol.Initial.InitPacketDeclaration;
import net.ME1312.SubData.Client.Protocol.Initial.InitialPacket;
import net.ME1312.SubData.Client.Protocol.Initial.InitialProtocol;
import net.ME1312.SubData.Client.Protocol.Internal.PacketDisconnect;
import net.ME1312.SubData.Client.Protocol.Internal.PacketDisconnectUnderstood;
import net.ME1312.SubData.Client.Protocol.Internal.PacketDownloadClientList;
import net.ME1312.SubData.Client.Protocol.Internal.PacketForwardPacket;
import net.ME1312.SubData.Client.Protocol.Internal.PacketPing;
import net.ME1312.SubData.Client.Protocol.Internal.PacketSendMessage;
import net.ME1312.SubData.Client.Protocol.MessageOut;
import net.ME1312.SubData.Client.Protocol.PacketIn;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.Protocol.PacketStreamIn;
import net.ME1312.SubData.Client.Protocol.PacketStreamOut;
import net.ME1312.SubData.Client.SubDataProtocol;
import net.ME1312.SubData.Client.SubDataSender;

public class SubDataClient
extends DataClient
implements SubDataSender {
    private Socket socket;
    private InetSocketAddress address;
    private InputStreamL1 in;
    private OutputStreamL1 out;
    private ExecutorService writer;
    private HashMap<ConnectionState, LinkedList<PacketOut>> statequeue;
    private Runnable readc;
    private int bs;
    private SubDataProtocol protocol;
    private Cipher cipher = NEH.get();
    private int cipherlevel = 0;
    private ObjectMap<?> login;
    private ConnectionState state;
    private DisconnectReason isdcr;
    private Consumer<Runnable> scheduler;
    private Object[] constructor;
    private SubDataClient next;
    private Logger log;
    private Timer heartbeat;

    SubDataClient(SubDataProtocol protocol, Consumer<Runnable> scheduler, Logger log, InetAddress address, int port, ObjectMap<?> login) throws IOException {
        Util.nullpo((Object[])new Serializable[]{address, Integer.valueOf(port)});
        this.protocol = protocol;
        this.bs = protocol.bs;
        this.login = login;
        this.scheduler = scheduler;
        this.log = log;
        this.state = ConnectionState.PRE_INITIALIZATION;
        this.isdcr = DisconnectReason.PROTOCOL_MISMATCH;
        this.socket = new Socket(address, port);
        this.address = new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort());
        this.writer = Executors.newSingleThreadExecutor(r -> new Thread(r, "SubDataClient::Data_Writer(" + this.address.toString() + ')'));
        this.out = new OutputStreamL1(log, this.socket.getOutputStream(), this.bs, () -> this.close(DisconnectReason.CONNECTION_INTERRUPTED), "SubDataClient::Block_Writer(" + this.address.toString() + ')');
        this.in = new InputStreamL1(new BufferedInputStream(this.socket.getInputStream()), () -> this.close(DisconnectReason.CONNECTION_INTERRUPTED), e -> {
            DebugUtil.logException(new ProtocolException(this.address.toString() + ": Received invalid L1 control character: " + DebugUtil.toHex(255, e)), log);
            this.close(DisconnectReason.PROTOCOL_MISMATCH);
        });
        this.statequeue = new HashMap();
        this.constructor = new Object[]{scheduler, log, address, port, login};
        this.heartbeat = new Timer("SubDataClient::Connection_Heartbeat(" + this.address.toString() + ')');
        this.heartbeat.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!SubDataClient.this.writer.isShutdown()) {
                    SubDataClient.this.writer.submit(() -> {
                        if (SubDataClient.this.heartbeat != null) {
                            SubDataClient.this.out.control(0);
                            final 1 action = this;
                            SubDataClient.this.heartbeat.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    action.run();
                                }
                            }, 5000L);
                        }
                    });
                }
            }
        }, 5000L);
        log.info("Connected to " + this.socket.getRemoteSocketAddress());
        this.read();
    }

    private void read(SubDataSender sender, Container<Boolean> reset, final InputStream data) {
        block19: {
            try {
                int b;
                byte[] pending = new byte[2];
                int id = -1;
                int i = 0;
                while ((b = data.read()) != -1) {
                    pending[i] = (byte)b;
                    if (++i != 2) continue;
                    id = (int)UnsignedData.resign(pending);
                    break;
                }
                if (this.state != ConnectionState.CLOSED && id >= 0) {
                    final Container open = new Container((Object)true);
                    InputStream forward = new InputStream(){

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            int i = data.read(b, off, len);
                            if (i == -1) {
                                open.value = false;
                            }
                            return i;
                        }

                        @Override
                        public int read() throws IOException {
                            int b = data.read();
                            if (b == -1) {
                                open.value = false;
                            }
                            return b;
                        }

                        @Override
                        public void close() throws IOException {
                            try {
                                while (data.read() != -1) {
                                }
                            }
                            finally {
                                open.value = false;
                            }
                        }
                    };
                    if (this.state == ConnectionState.PRE_INITIALIZATION && id != 0) {
                        throw new ProtocolException(this.address.toString() + ": Only 0x0000 may be received during the PRE_INITIALIZATION stage: [" + DebugUtil.toHex(65535, id) + "]");
                    }
                    if (this.state == ConnectionState.CLOSING && id != 65534) {
                        forward.close();
                    } else {
                        HashMap pIn;
                        HashMap hashMap = pIn = this.state.asInt() >= ConnectionState.POST_INITIALIZATION.asInt() ? this.protocol.pIn : (HashMap)Util.reflect((Field)InitialProtocol.class.getDeclaredField("pIn"), null);
                        if (!pIn.keySet().contains(id)) {
                            throw new IllegalPacketException(this.address.toString() + ": Could not find handler for packet: [" + DebugUtil.toHex(65535, id) + "]");
                        }
                        PacketIn packet = (PacketIn)pIn.get(id);
                        if (sender instanceof ForwardedDataSender && !(packet instanceof Forwardable)) {
                            throw new IllegalSenderException(this.address.toString() + ": This handler does not support forwarded packets: [" + packet.getClass().getTypeName() + "]");
                        }
                        if (sender instanceof SubDataClient && packet instanceof ForwardOnly) {
                            throw new IllegalSenderException(this.address.toString() + ": This handler does not support non-forwarded packets: [" + packet.getClass().getTypeName() + "]");
                        }
                        if (this.state == ConnectionState.PRE_INITIALIZATION && !(packet instanceof InitPacketDeclaration)) {
                            throw new ProtocolException(this.address.toString() + ": Only " + InitPacketDeclaration.class.getTypeName() + " may be received during the PRE_INITIALIZATION stage: [" + packet.getClass().getTypeName() + "]");
                        }
                        if (this.state == ConnectionState.CLOSING && !(packet instanceof PacketDisconnectUnderstood)) {
                            forward.close();
                        } else {
                            this.readc = () -> {
                                open.value = false;
                            };
                            this.scheduler.accept(() -> {
                                block4: {
                                    try {
                                        packet.receive(sender);
                                        if (packet instanceof PacketStreamIn) {
                                            ((PacketStreamIn)packet).receive(sender, forward);
                                        } else {
                                            forward.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        DebugUtil.logException(new InvocationTargetException(e, this.address.toString() + ": Exception while running packet handler"), this.log);
                                        Try.all.run(forward::close);
                                        if (this.state.asInt() > ConnectionState.INITIALIZATION.asInt()) break block4;
                                        Try.all.run(() -> this.close(DisconnectReason.PROTOCOL_MISMATCH));
                                    }
                                }
                            });
                            if (sender == this) {
                                while (((Boolean)open.value).booleanValue()) {
                                    Thread.sleep(125L);
                                }
                            }
                        }
                    }
                }
            }
            catch (InterruptedIOException pending) {
            }
            catch (ProtocolException e) {
                DebugUtil.logException(e, this.log);
                this.close(DisconnectReason.PROTOCOL_MISMATCH);
            }
            catch (Exception e) {
                if (((Boolean)reset.value).booleanValue()) break block19;
                if (!(e instanceof SocketException) || Boolean.getBoolean("subdata.debug")) {
                    DebugUtil.logException(e, this.log);
                }
                if (!(e instanceof SocketException)) {
                    this.close(DisconnectReason.UNHANDLED_EXCEPTION);
                }
                this.close(DisconnectReason.CONNECTION_INTERRUPTED);
            }
        }
    }

    void read() {
        if (!this.isClosed()) {
            new Thread(() -> {
                block7: {
                    Container reset = new Container((Object)false);
                    if (!this.isClosed()) {
                        try {
                            InputStream raw = this.in.open(() -> {
                                if (this.state != ConnectionState.PRE_INITIALIZATION) {
                                    reset.value = true;
                                }
                            }, () -> {
                                if (!this.isClosed()) {
                                    this.read();
                                } else {
                                    Try.all.run(() -> this.close(DisconnectReason.CONNECTION_INTERRUPTED));
                                }
                            });
                            PipedInputStream data = new PipedInputStream(1024);
                            PipedOutputStream forward = new PipedOutputStream(data);
                            Thread reader = new Thread(() -> this.read(this, (Container<Boolean>)reset, data), "SubDataClient::Packet_Reader(" + this.address.toString() + ')');
                            this.readc = reader::interrupt;
                            reader.start();
                            this.cipher.decrypt((DataClient)this, raw, (OutputStream)forward);
                            forward.close();
                        }
                        catch (Exception e) {
                            if (((Boolean)reset.value).booleanValue()) break block7;
                            if (!(e instanceof SocketException) || Boolean.getBoolean("subdata.debug")) {
                                DebugUtil.logException(e, this.log);
                            }
                            if (!(e instanceof SocketException)) {
                                if (e instanceof EncryptionException) {
                                    this.close(DisconnectReason.ENCRYPTION_MISMATCH);
                                } else {
                                    this.close(DisconnectReason.UNHANDLED_EXCEPTION);
                                }
                            }
                            this.close(DisconnectReason.CONNECTION_INTERRUPTED);
                        }
                    }
                }
            }, "SubDataClient::Data_Reader(" + this.address.toString() + ')').start();
        }
    }

    private void write(SubDataSender sender, PacketOut next, final OutputStream data) {
        try {
            HashMap pOut;
            final Container open = new Container((Object)true);
            OutputStream forward = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    data.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    data.write(b);
                }

                @Override
                public void close() throws IOException {
                    open.value = false;
                    data.close();
                }
            };
            HashMap hashMap = pOut = this.state.asInt() >= ConnectionState.POST_INITIALIZATION.asInt() ? this.protocol.pOut : (HashMap)Util.reflect((Field)InitialProtocol.class.getDeclaredField("pOut"), null);
            if (!pOut.keySet().contains(next.getClass())) {
                throw new IllegalMessageException(this.address.toString() + ": Could not find ID for packet: " + next.getClass().getTypeName());
            }
            data.write(UnsignedData.unsign(((Integer)pOut.get(next.getClass())).intValue(), 2), 0, 2);
            data.flush();
            this.scheduler.accept(() -> {
                try {
                    next.sending(sender);
                    if (next instanceof PacketStreamOut) {
                        ((PacketStreamOut)next).send(sender, forward);
                    } else {
                        forward.close();
                    }
                }
                catch (Throwable e) {
                    DebugUtil.logException(new InvocationTargetException(e, this.address.toString() + ": Exception while running packet writer"), this.log);
                    Try.all.run(forward::close);
                }
            });
            if (sender == this) {
                while (((Boolean)open.value).booleanValue()) {
                    Thread.sleep(125L);
                }
            }
        }
        catch (Throwable e) {
            DebugUtil.logException(e, this.log);
            Try.all.run(data::close);
        }
    }

    void write(PacketOut packet) {
        block6: {
            if (!(packet == null || this.isClosed() && (packet instanceof PacketDisconnect || packet instanceof PacketDisconnectUnderstood))) {
                if (!this.isClosed() && (this.state != ConnectionState.CLOSING || packet instanceof PacketDisconnect || packet instanceof PacketDisconnectUnderstood)) {
                    try {
                        PipedOutputStream data = new PipedOutputStream();
                        PipedInputStream forward = new PipedInputStream(data, 1024);
                        new Thread(() -> this.write(this, packet, data), "SubDataClient::Packet_Writer(" + this.address.toString() + ')').start();
                        this.cipher.encrypt((DataClient)this, (InputStream)forward, (OutputStream)this.out);
                        forward.close();
                        if (!this.socket.isClosed()) {
                            this.out.limit = this.bs;
                            this.out.flush();
                            this.out.control(23);
                        }
                        break block6;
                    }
                    catch (Throwable e) {
                        if (!(e instanceof SocketException)) {
                            DebugUtil.logException(e, this.log);
                        }
                        break block6;
                    }
                }
                this.sendPacket(packet);
            }
        }
    }

    @Override
    public void sendPacket(PacketOut ... packets) {
        for (PacketOut packet : packets) {
            if (Util.isNull((Object)packet)) continue;
            if (packet instanceof ForwardOnly) {
                throw new IllegalPacketException("Packet is Forward-Only");
            }
            if (this.isClosed() || this.state == ConnectionState.CLOSING && !(packet instanceof PacketDisconnect) && !(packet instanceof PacketDisconnectUnderstood)) {
                if (this.next == null) {
                    this.sendPacketLater(packet, ConnectionState.CLOSED);
                    continue;
                }
                this.next.sendPacket(packet);
                continue;
            }
            if (this.state.asInt() < ConnectionState.POST_INITIALIZATION.asInt() && !(packet instanceof InitialProtocol.Packet)) {
                this.sendPacketLater(packet, packet instanceof InitialPacket ? ConnectionState.POST_INITIALIZATION : ConnectionState.READY);
                continue;
            }
            if (this.state == ConnectionState.POST_INITIALIZATION && !(packet instanceof InitialPacket)) {
                this.sendPacketLater(packet, ConnectionState.READY);
                continue;
            }
            if (this.writer.isShutdown()) continue;
            this.writer.submit(() -> this.write(packet));
        }
    }

    private void sendPacketLater(PacketOut packet, ConnectionState state) {
        LinkedList<PacketOut> prequeue = this.statequeue.keySet().contains((Object)state) ? this.statequeue.get((Object)state) : new LinkedList<PacketOut>();
        prequeue.add(packet);
        this.statequeue.put(state, prequeue);
    }

    public void forwardPacket(UUID id, PacketOut ... packets) {
        ArrayList list = new ArrayList();
        for (PacketOut packet : packets) {
            if (Util.isNull((Object[])new Object[]{id, packet})) continue;
            if (!(packet instanceof Forwardable)) {
                throw new IllegalPacketException("Packet is not Forwardable");
            }
            this.sendPacket(new PacketForwardPacket(id, packet));
        }
        this.sendPacket(list.toArray(new PacketOut[0]));
    }

    public void sendMessage(MessageOut ... messages) {
        ArrayList<PacketSendMessage> list = new ArrayList<PacketSendMessage>();
        for (MessageOut message : messages) {
            if (Util.isNull((Object)message)) continue;
            if (message instanceof ForwardOnly) {
                throw new IllegalMessageException("Message is Forward-Only");
            }
            list.add(new PacketSendMessage(message));
        }
        this.sendPacket(list.toArray(new PacketOut[0]));
    }

    public void forwardMessage(UUID id, MessageOut ... messages) {
        Util.nullpo((Object)id);
        ArrayList<PacketForwardPacket> list = new ArrayList<PacketForwardPacket>();
        for (MessageOut message : messages) {
            if (Util.isNull((Object)message)) continue;
            if (!(message instanceof Forwardable)) {
                throw new IllegalMessageException("Message is not Forwardable");
            }
            list.add(new PacketForwardPacket(id, new PacketSendMessage(message)));
        }
        this.sendPacket(list.toArray(new PacketOut[0]));
    }

    public void getClient(UUID id, Consumer<ObjectMap<String>> callback) {
        Util.nullpo((Object[])new Object[]{id, callback});
        StackTraceElement[] origin = new Exception().getStackTrace();
        this.sendPacket(new PacketDownloadClientList(id, data -> {
            ObjectMap serialized = null;
            if (data.contains((Object)id.toString())) {
                serialized = data.getMap((Object)id.toString());
            }
            try {
                callback.accept(serialized);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        }));
    }

    public void getClients(Consumer<Map<UUID, ObjectMap<String>>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Exception().getStackTrace();
        this.sendPacket(new PacketDownloadClientList(data -> {
            HashMap<UUID, ObjectMap> serialized = new HashMap<UUID, ObjectMap>();
            for (String id : data.getKeys()) {
                serialized.put(UUID.fromString(id), data.getMap((Object)id));
            }
            try {
                callback.accept(serialized);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        }));
    }

    public void ping(Consumer<PingResponse> response) {
        Util.nullpo(response);
        this.sendPacket(new PacketPing(response));
    }

    public void ping(UUID id, Consumer<PingResponse> response) {
        Util.nullpo(response);
        this.forwardPacket(id, new PacketPing(response));
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    @Deprecated
    public SubDataClient getConnection() {
        return this;
    }

    @Override
    public SubDataProtocol getProtocol() {
        return this.protocol;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getBlockSize() {
        return this.bs;
    }

    public void setBlockSize(Integer size) {
        this.bs = size == null ? this.protocol.bs : size;
        this.out.limit = this.bs;
    }

    public void tempBlockSize(Integer size) {
        this.out.resize(size == null ? this.bs : size);
    }

    @Deprecated
    public DataClient newChannel() throws IOException {
        return this.openChannel();
    }

    public SubDataClient openChannel() throws IOException {
        return this.protocol.sub((Consumer)this.constructor[0], (Logger)this.constructor[1], (InetAddress)this.constructor[2], (Integer)this.constructor[3], (ObjectMap)this.constructor[4]);
    }

    public void reconnect(SubDataClient client) {
        Util.nullpo((Object)client);
        if (client == this) {
            throw new IllegalArgumentException("Cannot reconnect to 'this'");
        }
        if (this.state.asInt() < ConnectionState.CLOSING.asInt() || this.next != null) {
            throw new IllegalStateException("Cannot override existing data stream");
        }
        this.next = client;
        if (this.statequeue.keySet().contains((Object)ConnectionState.CLOSED)) {
            for (PacketOut packet : this.statequeue.get((Object)ConnectionState.CLOSED)) {
                this.next.sendPacket(packet);
            }
            this.statequeue.remove((Object)ConnectionState.CLOSED);
        }
    }

    public void close() {
        if (this.state.asInt() < ConnectionState.CLOSING.asInt() && !this.socket.isClosed()) {
            boolean result = true;
            LinkedList events = new LinkedList(this.on.close);
            for (Function next : events) {
                try {
                    if (next == null) continue;
                    result = next.apply(this) != Boolean.FALSE && result;
                }
                catch (Throwable e) {
                    DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.log);
                }
            }
            if (result) {
                this.state = ConnectionState.CLOSING;
                if (!this.isClosed()) {
                    this.sendPacket(new PacketDisconnect());
                }
                final Timer timeout = new Timer("SubDataClient::Disconnect_Timeout(" + this.address.toString() + ')');
                timeout.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (!SubDataClient.this.socket.isClosed()) {
                            SubDataClient.this.close(DisconnectReason.CLOSE_REQUESTED);
                        }
                        timeout.cancel();
                    }
                }, 5000L);
            }
        }
    }

    void close(DisconnectReason reason) {
        if (this.state != ConnectionState.CLOSED) {
            if (this.state == ConnectionState.CLOSING && reason == DisconnectReason.CONNECTION_INTERRUPTED) {
                reason = DisconnectReason.CLOSE_REQUESTED;
            } else if (this.isdcr != null && reason == DisconnectReason.CONNECTION_INTERRUPTED) {
                reason = this.isdcr;
            }
            this.state = ConnectionState.CLOSED;
            if (this.readc != null) {
                this.readc.run();
            }
            if (reason != DisconnectReason.CLOSE_REQUESTED) {
                this.log.warning("Disconnected from " + this.socket.getRemoteSocketAddress() + ": " + reason);
            } else {
                this.log.info("Disconnected from " + this.socket.getRemoteSocketAddress());
            }
            this.heartbeat.cancel();
            this.heartbeat = null;
            this.writer.shutdown();
            this.out.shutdown();
            this.in.shutdown();
            try {
                this.socket.close();
            }
            catch (IOException e) {
                DebugUtil.logException(e, this.log);
            }
            this.cipher.retire((DataClient)this);
            DisconnectReason freason = reason;
            this.scheduler.accept(() -> {
                LinkedList events = new LinkedList(this.on.closed);
                for (Consumer next : events) {
                    try {
                        if (next == null) continue;
                        next.accept(new ContainedPair((Object)freason, (Object)this));
                    }
                    catch (Throwable e) {
                        DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.log);
                    }
                }
            });
        }
    }

    public boolean isClosed() {
        return this.state == ConnectionState.CLOSED || this.socket.isClosed();
    }
}

