/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.Cipher;
import net.ME1312.SubData.Client.DataProtocol;
import net.ME1312.SubData.Client.Encryption.NEH;
import net.ME1312.SubData.Client.Library.DebugUtil;
import net.ME1312.SubData.Client.Protocol.Initial.InitPacketVerifyState;
import net.ME1312.SubData.Client.Protocol.Internal.PacketDisconnect;
import net.ME1312.SubData.Client.Protocol.Internal.PacketDisconnectUnderstood;
import net.ME1312.SubData.Client.Protocol.Internal.PacketDownloadClientList;
import net.ME1312.SubData.Client.Protocol.Internal.PacketForwardPacket;
import net.ME1312.SubData.Client.Protocol.Internal.PacketNull;
import net.ME1312.SubData.Client.Protocol.Internal.PacketOpenChannel;
import net.ME1312.SubData.Client.Protocol.Internal.PacketPing;
import net.ME1312.SubData.Client.Protocol.Internal.PacketPingResponse;
import net.ME1312.SubData.Client.Protocol.Internal.PacketRecieveMessage;
import net.ME1312.SubData.Client.Protocol.Internal.PacketSendMessage;
import net.ME1312.SubData.Client.Protocol.PacketIn;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;

public class SubDataProtocol
extends DataProtocol {
    public static final int MIN_PACKET_ID = 0;
    public static final int MAX_PACKET_ID = 65519;
    final HashMap<String, Cipher> ciphers = new HashMap();
    final HashMap<Class<? extends PacketOut>, Integer> pOut = new HashMap();
    final HashMap<Integer, PacketIn> pIn = new HashMap();
    ArrayList<Version> version = new ArrayList();
    String name;
    int bs = 4096;

    public SubDataProtocol() {
        this.ciphers.put("NULL", NEH.get());
        this.ciphers.put("NONE", NEH.get());
        this.pIn.put(65526, new PacketDownloadClientList());
        this.pIn.put(65527, new PacketOpenChannel(null, false));
        this.pIn.put(65528, new PacketPingResponse());
        this.pIn.put(65529, new PacketPing());
        this.pIn.put(65530, new InitPacketVerifyState());
        this.pIn.put(65531, new PacketRecieveMessage());
        this.pIn.put(65532, new PacketForwardPacket(null, null));
        this.pIn.put(65533, new PacketNull());
        this.pIn.put(65534, new PacketDisconnectUnderstood());
        this.pIn.put(65535, new PacketDisconnect());
        this.pOut.put(PacketDownloadClientList.class, 65526);
        this.pOut.put(PacketOpenChannel.class, 65527);
        this.pOut.put(PacketPingResponse.class, 65528);
        this.pOut.put(PacketPing.class, 65529);
        this.pOut.put(InitPacketVerifyState.class, 65530);
        this.pOut.put(PacketSendMessage.class, 65531);
        this.pOut.put(PacketForwardPacket.class, 65532);
        this.pOut.put(PacketNull.class, 65533);
        this.pOut.put(PacketDisconnectUnderstood.class, 65534);
        this.pOut.put(PacketDisconnect.class, 65535);
    }

    protected SubDataClient sub(Consumer<Runnable> scheduler, Logger logger, InetAddress address, int port, ObjectMap<?> login) throws IOException {
        return this.open(scheduler, logger, address, port, login);
    }

    public SubDataClient open(Consumer<Runnable> scheduler, Logger logger, InetAddress address, int port, ObjectMap<?> login) throws IOException {
        return new SubDataClient(this, scheduler, logger, address, port, login);
    }

    public SubDataClient open(Consumer<Runnable> scheduler, Logger logger, InetAddress address, int port) throws IOException {
        return this.open(scheduler, logger, address, port, null);
    }

    public SubDataClient open(Logger logger, InetAddress address, int port, ObjectMap<?> login) throws IOException {
        return this.open(Runnable::run, logger, address, port, login);
    }

    public SubDataClient open(Logger logger, InetAddress address, int port) throws IOException {
        return this.open(Runnable::run, logger, address, port);
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("Protocol name already set");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addVersion(Version version) {
        if (!this.version.contains(version)) {
            this.version.add(version);
        }
    }

    public void removeVersion(Version version) {
        this.version.remove(version);
    }

    public Version[] getVersion() {
        if (this.version.size() <= 0) {
            return new Version[]{new Version(new int[]{0})};
        }
        return this.version.toArray(new Version[0]);
    }

    public int getBlockSize() {
        return this.bs;
    }

    public void setBlockSize(int size) {
        this.bs = size;
    }

    public void registerCipher(String handle, Cipher cipher) {
        Util.nullpo((Object)cipher);
        if (!handle.equalsIgnoreCase("NULL")) {
            this.ciphers.put(handle.toUpperCase(), cipher);
        }
    }

    public void unregisterCipher(String handle) {
        if (!handle.equalsIgnoreCase("NULL")) {
            this.ciphers.remove(handle.toUpperCase());
        }
    }

    public void registerPacket(int id, PacketIn packet) {
        Util.nullpo((Object)packet);
        if (id > 65519 || id < 0) {
            throw new IllegalArgumentException("Packet ID is not in range (" + DebugUtil.toHex(65535, 0) + " to " + DebugUtil.toHex(65535, 65519) + "): " + DebugUtil.toHex(65535, id));
        }
        this.pIn.put(id, packet);
    }

    public void unregisterPacket(PacketIn packet) {
        Util.nullpo((Object)packet);
        ArrayList<Integer> search = new ArrayList<Integer>(this.pIn.keySet());
        Iterator iterator = search.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (!this.pIn.get(id).equals(packet) || id >= 65519) continue;
            this.pIn.remove(id);
        }
    }

    public void registerPacket(int id, Class<? extends PacketOut> packet) {
        Util.nullpo(packet);
        if (id > 65519 || id < 0) {
            throw new IllegalArgumentException("Packet ID is not in range (" + DebugUtil.toHex(65535, 0) + " to " + DebugUtil.toHex(65535, 65519) + "): " + DebugUtil.toHex(65535, id));
        }
        this.pOut.put(packet, id);
    }

    public void unregisterPacket(Class<? extends PacketOut> packet) {
        Util.nullpo(packet);
        if (this.pOut.containsKey(packet) && this.pOut.get(packet) < 65519) {
            this.pOut.remove(packet);
        }
    }

    public PacketIn getPacket(int id) {
        return this.pIn.get(id);
    }
}

