/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit.Graphic;

import com.connorlinfoot.titleapi.TitleAPI;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubServers.Client.Bukkit.Graphic.PluginRenderer;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.AgnosticScheduler;
import net.ME1312.SubServers.Client.Bukkit.SubPlugin;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class UIRenderer {
    private final boolean USE_TITLES;
    private final boolean TAPI_1_11;
    private final boolean TAPI_PLUGIN;
    private final MethodHandle MAPI_1_13;
    static final HashMap<String, PluginRenderer<Host>> hostPlugins = new HashMap();
    static final HashMap<String, PluginRenderer<Server>> serverPlugins = new HashMap();
    private final String[] downloadA;
    private final int downloadL;
    private int downloadF;
    private String downloadT;
    private Runnable download;
    final Player player;
    final SubPlugin plugin;

    public UIRenderer(SubPlugin plugin, Player player) {
        Util.nullpo((Object[])new Object[]{plugin, player});
        this.plugin = plugin;
        this.player = player;
        this.MAPI_1_13 = plugin.api.getGameVersion().compareTo(new Version("1.13")) < 0 ? null : (MethodHandle)Try.all.get(() -> MethodHandles.publicLookup().findStatic(Material.class, "getMaterial", MethodType.methodType(Material.class, new Class[]{String.class, Boolean.TYPE})));
        this.USE_TITLES = plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Use-Title-Messages", Boolean.valueOf(true));
        if (this.USE_TITLES) {
            this.TAPI_1_11 = plugin.api.getGameVersion().compareTo(new Version("1.11")) >= 0;
            this.TAPI_PLUGIN = this.TAPI_1_11 ? false : Bukkit.getPluginManager().getPlugin("TitleAPI") != null;
        } else {
            this.TAPI_PLUGIN = false;
            this.TAPI_1_11 = false;
        }
        String a = plugin.api.getLang("SubServers", "Interface.Generic.Downloading.Title-Color-Alt");
        String b = plugin.api.getLang("SubServers", "Interface.Generic.Downloading.Title-Color");
        String word = ChatColor.stripColor((String)plugin.api.getLang("SubServers", "Interface.Generic.Downloading.Title"));
        String bword = b + word;
        LinkedList<String> frames = new LinkedList<String>();
        for (int i = 0; i < 10; ++i) {
            frames.add(bword);
        }
        int wordpoints = (int)word.codePoints().count();
        int frame = 0;
        while (true) {
            int start = Math.max(++frame - 3, 0);
            int end = Math.min(frame, wordpoints);
            if (start >= wordpoints) break;
            StringBuilder s = new StringBuilder(start == 0 ? a : b);
            int i = 0;
            PrimitiveIterator.OfInt iterator = word.codePoints().iterator();
            while (iterator.hasNext()) {
                if (start == ++i) {
                    s.append(a);
                }
                s.appendCodePoint(iterator.nextInt());
                if (end != i) continue;
                s.append(b);
            }
            frames.add(s.toString());
        }
        this.downloadA = frames.toArray(new String[0]);
        this.downloadL = this.downloadA.length;
    }

    public abstract void newUI();

    public abstract void clearHistory();

    public abstract boolean hasHistory();

    public abstract void reopen();

    public abstract void back();

    public boolean sendTitle(String str) {
        return this.sendTitle(str, -1);
    }

    public boolean sendTitle(String str, int stay) {
        return this.sendTitle(str, -1, stay, -1);
    }

    public boolean sendTitle(String str, int fadein, int stay, int fadeout) {
        String line1;
        String line2;
        if (str == null) {
            line2 = null;
            line1 = null;
        } else if (!str.contains("\n")) {
            line1 = str;
            line2 = ChatColor.RESET.toString();
        } else if (str.startsWith("\n")) {
            line1 = str.replace("\n", "");
            line2 = ChatColor.RESET.toString();
        } else {
            String[] arr = str.split("\\n", 2);
            line1 = arr[0];
            line2 = arr[1];
        }
        return this.sendTitle(line1, line2, fadein, stay, fadeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendTitle(String line1, String line2, int fadein, int stay, int fadeout) {
        if (!this.USE_TITLES) {
        }
        if (!this.player.isOnline()) {
        }
        try {
            if (this.TAPI_1_11) {
                if (line1 == null) {
                    this.player.resetTitle();
                    return true;
                }
                this.player.sendTitle(line1, line2, fadein >= 0 ? fadein : 10, stay >= 0 ? stay : 70, fadeout >= 0 ? fadeout : 20);
                return true;
            }
            if (this.TAPI_PLUGIN) {
                if (line1 == null) {
                    TitleAPI.clearTitle((Player)this.player);
                    return true;
                }
                TitleAPI.sendTitle((Player)this.player, (Integer)(fadein >= 0 ? fadein : 10), (Integer)(stay >= 0 ? stay : 70), (Integer)(fadeout >= 0 ? fadeout : 20), (String)line1, (String)line2);
                return true;
            }
        }
        finally {
            return false;
        }
    }

    public boolean canSendTitle() {
        return this.USE_TITLES && (this.TAPI_1_11 || this.TAPI_PLUGIN);
    }

    public void setDownloading(String subtitle) {
        if (this.player.isOnline()) {
            if (subtitle != null) {
                if (!this.canSendTitle()) {
                    String text = subtitle;
                    if (this.download != null) {
                        this.download.run();
                    }
                    this.download = AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, cancel -> {
                        if (this.downloadT != null && this.player.isOnline()) {
                            this.player.sendMessage(this.plugin.api.getLang("SubServers", "Interface.Generic.Downloading").replace("$str$", text));
                        }
                        this.download = null;
                    }, 2500L, TimeUnit.MILLISECONDS);
                    return;
                }
                if (!subtitle.startsWith(Character.toString('\u00a7'))) {
                    subtitle = this.plugin.api.getLang("SubServers", "Interface.Generic.Downloading.Title-Color-Alt") + subtitle;
                }
                if (this.downloadT == null) {
                    this.downloadT = subtitle;
                    this.downloadF = 0;
                    AgnosticScheduler.following((Entity)this.player).repeats((Plugin)this.plugin, cancel -> {
                        if (this.downloadT != null) {
                            if (++this.downloadF >= this.downloadL) {
                                this.downloadF = 0;
                            }
                            if (!this.sendTitle(this.downloadA[this.downloadF], this.downloadT, 0, 10, 5)) {
                                cancel.run();
                            }
                        } else {
                            this.sendTitle(null);
                            cancel.run();
                        }
                    }, 0L, 50L, TimeUnit.MILLISECONDS);
                } else {
                    this.downloadT = subtitle;
                }
            } else {
                if (this.downloadT != null) {
                    this.downloadT = null;
                }
                if (this.download != null) {
                    this.download.run();
                    this.download = null;
                }
            }
        }
    }

    public ItemStack parseItem(String str) {
        return this.parseItem(str, new ItemStack(Material.AIR));
    }

    public ItemStack parseItem(String str, ItemStack def) {
        block17: {
            Matcher matcher;
            Container item = new Container((Object)str);
            if (this.MAPI_1_13 == null) {
                try {
                    matcher = Pattern.compile("(?i)^(\\d+)$").matcher((CharSequence)item.value);
                    if (matcher.find()) {
                        return new ItemStack(Integer.parseInt(matcher.group(1)), 1);
                    }
                    matcher.reset();
                    matcher = Pattern.compile("(?i)^(\\d+):(\\d+)$").matcher((CharSequence)item.value);
                    if (matcher.find()) {
                        return new ItemStack(Integer.parseInt(matcher.group(1)), 1, Short.parseShort(matcher.group(2)));
                    }
                }
                catch (Exception e) {
                    return def;
                }
            }
            if (((String)item.value).toLowerCase().startsWith("minecraft:")) {
                item.value((Object)((String)item.value).substring(10));
            } else if (((String)item.value).toLowerCase().startsWith("bukkit:")) {
                item.value((Object)((String)item.value).substring(7));
                matcher = Pattern.compile("(?i)\\W(\\d+)$").matcher((CharSequence)item.value);
                try {
                    if (matcher.find()) {
                        item.value((Object)((String)item.value).substring(0, ((String)item.value).length() - matcher.group().length()));
                        return new ItemStack(Material.valueOf((String)((String)item.value).toUpperCase()), 1, Short.parseShort(matcher.group(1)));
                    }
                    return new ItemStack(Material.valueOf((String)((String)item.value).toUpperCase()), 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.MAPI_1_13 == null) {
                try {
                    return new ItemStack(Material.valueOf((String)((String)item.value).toUpperCase()), 1);
                }
                catch (IllegalArgumentException matcher2) {
                    break block17;
                }
            }
            try {
                Material material = this.MAPI_1_13.invokeExact(((String)item.value).toUpperCase(), false);
                if (material != null) {
                    return new ItemStack(material, 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return def;
    }

    public static void addHostPlugin(String handle, PluginRenderer<Host> renderer) {
        Util.nullpo((Object[])new Object[]{handle, renderer});
        hostPlugins.put(handle, renderer);
    }

    public static Map<String, PluginRenderer<Host>> getHostPlugins() {
        return new HashMap<String, PluginRenderer<Host>>(hostPlugins);
    }

    public static void removeHostPlugin(String handle) {
        Util.nullpo((Object)handle);
        hostPlugins.remove(handle);
    }

    public static void addServerPlugin(String handle, PluginRenderer<Server> renderer) {
        Util.nullpo((Object[])new Object[]{handle, renderer});
        serverPlugins.put(handle, renderer);
    }

    public static Map<String, PluginRenderer<Server>> getServerPlugins() {
        return new HashMap<String, PluginRenderer<Server>>(serverPlugins);
    }

    public static void removeServerPlugin(String handle) {
        Util.nullpo((Object)handle);
        serverPlugins.remove(handle);
    }

    public abstract void hostMenu(int var1);

    public abstract void hostAdmin(String var1);

    public abstract void hostCreator(CreatorOptions var1);

    public abstract void hostPlugin(int var1, String var2);

    public abstract void groupMenu(int var1);

    public abstract void serverMenu(int var1, String var2, String var3);

    public abstract void serverAdmin(String var1);

    public abstract void serverPlugin(int var1, String var2);

    public static class CreatorOptions
    extends Options {
        private String host;
        private String name = null;
        private String template = null;
        private Version version = null;
        private Integer port = null;

        public CreatorOptions(String host) {
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            Util.nullpo((Object)value);
            String name = this.name;
            this.history.add(() -> {
                this.name = name;
            });
            this.name = value;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String value) {
            Util.nullpo((Object)value);
            String template = this.template;
            this.history.add(() -> {
                this.template = template;
            });
            this.template = value;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version value) {
            Version version = this.version;
            this.history.add(() -> {
                this.version = version;
            });
            this.version = value;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer value) {
            Integer port = this.port;
            this.history.add(() -> {
                this.port = port;
            });
            this.port = value;
        }
    }

    public static abstract class Options {
        List<Runnable> history = new LinkedList<Runnable>();
        private boolean init = false;

        public boolean init() {
            if (!this.init) {
                this.init = true;
                return false;
            }
            return true;
        }

        public boolean hasHistory() {
            return !this.history.isEmpty();
        }

        public void undo() {
            Runnable lastWindow = this.history.get(this.history.size() - 1);
            this.history.remove(this.history.size() - 1);
            lastWindow.run();
        }
    }
}

