/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit.Library;

import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;

public enum SignState {
    UNKNOWN(0, "Signs.Text.Unknown"),
    OFFLINE(1, "Signs.Text.Offline"),
    STARTING(3, "Signs.Text.Starting"),
    ONLINE(4, "Signs.Text.Online"),
    STOPPING(2, "Signs.Text.Stopping");

    public final byte priority;
    public final String text;

    private SignState(int priority, String text) {
        this.priority = (byte)priority;
        this.text = text;
    }

    public static SignState determine(SubServer server) {
        if (!server.isRunning()) {
            return OFFLINE;
        }
        if (server.isStopping()) {
            return STOPPING;
        }
        if (server.isOnline()) {
            return ONLINE;
        }
        return STARTING;
    }

    public static SignState determine(Server server) {
        if (server instanceof SubServer) {
            return SignState.determine((SubServer)server);
        }
        if (server.getSubData()[0] == null) {
            return UNKNOWN;
        }
        return ONLINE;
    }
}

