/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.DataProtocol;
import net.ME1312.SubServers.Client.Bukkit.Graphic.UIHandler;
import net.ME1312.SubServers.Client.Bukkit.Library.AccessMode;
import net.ME1312.SubServers.Client.Bukkit.SubPlugin;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import org.bukkit.Bukkit;

public final class SubAPI
extends ClientAPI {
    LinkedList<Runnable> reloadListeners = new LinkedList();
    private final SubPlugin plugin;
    private static SubAPI api;
    AccessMode access;
    String name;
    private final Version GAME_VERSION;

    SubAPI(SubPlugin plugin) {
        this.plugin = plugin;
        this.GAME_VERSION = this.getGameVersion();
        this.access = AccessMode.DEFAULT;
        api = this;
    }

    public static SubAPI getInstance() {
        return api;
    }

    @Deprecated
    public SubPlugin getInternals() {
        return this.plugin;
    }

    public void addListener(Runnable reload) {
        if (reload != null) {
            this.reloadListeners.add(reload);
        }
    }

    public String getName() {
        return this.name;
    }

    public DataClient[] getSubDataNetwork() {
        Object[] keys = this.plugin.subdata.keySet().toArray(new Integer[0]);
        DataClient[] channels = new DataClient[keys.length];
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            channels[i] = (DataClient)this.plugin.subdata.get(keys[i]);
        }
        return channels;
    }

    public DataProtocol getSubDataProtocol() {
        return this.plugin.subprotocol;
    }

    public Collection<String> getLangChannels() {
        return ((Map)this.plugin.lang.value()).keySet();
    }

    public Map<String, String> getLang(String channel) {
        Util.nullpo((Object)channel);
        return new LinkedHashMap<String, String>((Map)((Map)this.plugin.lang.value()).get(channel.toLowerCase()));
    }

    public AccessMode getAccessMode() {
        return this.access;
    }

    public void setAccessMode(AccessMode mode) {
        if (mode.value <= this.access.value && !this.plugin.isEnabled()) {
            this.access = mode;
        }
    }

    public UIHandler getGraphicHandler() {
        return this.plugin.gui;
    }

    public void setGraphicHandler(UIHandler graphics) {
        if (this.plugin.gui != null) {
            this.plugin.gui.disable();
        }
        this.plugin.gui = graphics;
    }

    public Version getPluginVersion() {
        return this.plugin.version;
    }

    public Version getPluginBuild() {
        return SubPlugin.class.getPackage().getSpecificationTitle() != null ? new Version(SubPlugin.class.getPackage().getSpecificationTitle()) : null;
    }

    public Version getServerVersion() {
        return new Version(Bukkit.getServer().getVersion());
    }

    public Version getGameVersion() {
        if (this.GAME_VERSION == null) {
            if (System.getProperty("subservers.minecraft.version", "").length() > 0) {
                return new Version(System.getProperty("subservers.minecraft.version"));
            }
            try {
                return new Version(Bukkit.getBukkitVersion().split("-")[0]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.plugin.getLogger().warning("Could not determine this server's game version; Now using 1.x.x as a placeholder.");
                this.plugin.getLogger().warning("Use this launch argument to specify what version this server serves: -Dsubservers.minecraft.version=1.x.x");
                return new Version("1.x.x");
            }
        }
        return this.GAME_VERSION;
    }
}

