/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Config.YAMLSection;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Merger;
import net.ME1312.Galaxi.Library.Platform;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Bukkit.Graphic.UIRenderer;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.AgnosticScheduler;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.BungeeChat;
import net.ME1312.SubServers.Client.Bukkit.Library.ObjectPermission;
import net.ME1312.SubServers.Client.Bukkit.Network.Packet.PacketInExRunEvent;
import net.ME1312.SubServers.Client.Bukkit.SubPlugin;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Proxy;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubCreator;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketCreateServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketRestartServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketUpdateServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public final class SubCommand
extends Command {
    private SubPlugin plugin;

    public SubCommand(SubPlugin plugin, String name) {
        super(name, "The SubServers Command", "/" + name + " is currently unavailable", Collections.emptyList());
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (this.plugin.api.getSubDataNetwork()[0] == null || this.plugin.api.getSubDataNetwork()[0].isClosed()) {
            new IllegalStateException("SubData is not connected").printStackTrace();
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(ChatColor.RED + "An exception has occurred while running this command");
            }
        } else if (this.plugin.lang == null) {
            new IllegalStateException("There are no lang options available at this time").printStackTrace();
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(ChatColor.RED + "An exception has occurred while running this command");
            }
        } else {
            label = "/" + label;
            if (sender.hasPermission("subservers.command")) {
                if (args.length > 0) {
                    if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                        sender.sendMessage(this.printHelp(label));
                    } else if (args[0].equalsIgnoreCase("version") || args[0].equalsIgnoreCase("ver")) {
                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Version").replace("$str$", "SubServers.Client.Bukkit"));
                        sender.sendMessage(ChatColor.WHITE + "  " + Platform.getSystemName() + ' ' + Platform.getSystemVersion() + (Platform.getSystemBuild() != null ? " (" + Platform.getSystemBuild() + ')' : "") + (!Platform.getSystemArchitecture().equals("unknown") ? " [" + Platform.getSystemArchitecture() + ']' : "") + ChatColor.RESET + ',');
                        sender.sendMessage(ChatColor.WHITE + "  Java " + Platform.getJavaVersion() + (!Platform.getJavaArchitecture().equals("unknown") ? " [" + Platform.getJavaArchitecture() + ']' : "") + ChatColor.RESET + ',');
                        sender.sendMessage(ChatColor.WHITE + "  " + Bukkit.getName() + ' ' + Bukkit.getVersion() + ChatColor.RESET + ',');
                        sender.sendMessage(ChatColor.WHITE + "  SubServers.Client.Bukkit v" + this.plugin.version.toExtendedString() + (this.plugin.api.getPluginBuild() != null ? " (" + this.plugin.api.getPluginBuild() + ')' : ""));
                        sender.sendMessage("");
                        AgnosticScheduler.async.runs((Plugin)this.plugin, c -> {
                            try {
                                YAMLSection tags = new YAMLSection(this.plugin.parseJSON("{\"tags\":" + Util.readAll((Reader)new BufferedReader(new InputStreamReader(new URL("https://api.github.com/repos/ME1312/SubServers-2/git/refs/tags").openStream(), Charset.forName("UTF-8")))) + '}'));
                                LinkedList<Version> versions = new LinkedList<Version>();
                                Version updversion = this.plugin.version;
                                int updcount = 0;
                                for (ObjectMap tag : tags.getMapList((Object)"tags")) {
                                    versions.add(Version.fromString((String)tag.getString((Object)"ref").substring(10)));
                                }
                                Collections.sort(versions);
                                for (Version version : versions) {
                                    if (version.compareTo(updversion) <= 0) continue;
                                    updversion = version;
                                    ++updcount;
                                }
                                if (updcount == 0) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Version.Latest"));
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Version.Outdated").replace("$name$", "SubServers.Client.Bukkit").replace("$str$", updversion.toString()).replace("$int$", Integer.toString(updcount)));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                    } else if (args[0].equalsIgnoreCase("list")) {
                        if (((Boolean)Try.all.get(() -> Class.forName("net.md_5.bungee.api.chat.BaseComponent") != null, (Object)false)).booleanValue() && sender instanceof Player) {
                            new BungeeChat(this.plugin).listCommand(sender, label);
                        } else {
                            String fLabel = label;
                            this.plugin.api.getGroups(groups -> this.plugin.api.getHosts(hosts -> this.plugin.api.getServers(servers -> this.plugin.api.getProxies(proxies -> {
                                String message;
                                int i = 0;
                                boolean sent = false;
                                String div = this.plugin.api.getLang("SubServers", "Command.List.Divider");
                                if (groups.keySet().size() > 0) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.List.Group-Header"));
                                    for (String group : groups.keySet()) {
                                        message = "  ";
                                        message = message + ChatColor.GOLD + group + this.plugin.api.getLang("SubServers", "Command.List.Header");
                                        for (Server server : (List)groups.get(group)) {
                                            if (i != 0) {
                                                message = message + div;
                                            }
                                            message = !(server instanceof SubServer) ? message + ChatColor.WHITE : (((SubServer)server).isRunning() ? (((SubServer)server).getStopAction() == SubServer.StopAction.REMOVE_SERVER || ((SubServer)server).getStopAction() == SubServer.StopAction.RECYCLE_SERVER || ((SubServer)server).getStopAction() == SubServer.StopAction.DELETE_SERVER ? message + ChatColor.AQUA : message + ChatColor.GREEN) : (((SubServer)server).isAvailable() && ((SubServer)server).isEnabled() && ((SubServer)server).getCurrentIncompatibilities().size() == 0 ? message + ChatColor.YELLOW : message + ChatColor.RED));
                                            message = message + server.getDisplayName() + (server.getName().equals(server.getDisplayName()) ? "" : " [" + server.getName() + ']');
                                            ++i;
                                        }
                                        if (i == 0) {
                                            message = message + this.plugin.api.getLang("SubServers", "Command.List.Empty");
                                        }
                                        sender.sendMessage(message);
                                        i = 0;
                                        sent = true;
                                    }
                                    if (!sent) {
                                        sender.sendMessage("  " + this.plugin.api.getLang("SubServers", "Command.List.Empty"));
                                    }
                                    sent = false;
                                }
                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.List.Host-Header"));
                                for (Host host : hosts.values()) {
                                    message = "  ";
                                    message = host.isAvailable() && host.isEnabled() ? message + ChatColor.AQUA : message + ChatColor.RED;
                                    message = message + host.getDisplayName();
                                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                                        message = message + " [" + (host.getName().equals(host.getDisplayName()) ? "" : host.getName() + ChatColor.stripColor((String)div)) + host.getAddress() + "]";
                                    } else if (!host.getName().equals(host.getDisplayName())) {
                                        message = message + " [" + host.getName() + "]";
                                    }
                                    message = message + this.plugin.api.getLang("SubServers", "Command.List.Header");
                                    for (SubServer subserver : host.getSubServers().values()) {
                                        if (i != 0) {
                                            message = message + div;
                                        }
                                        message = subserver.isRunning() ? (subserver.getStopAction() == SubServer.StopAction.REMOVE_SERVER || subserver.getStopAction() == SubServer.StopAction.RECYCLE_SERVER || subserver.getStopAction() == SubServer.StopAction.DELETE_SERVER ? message + ChatColor.AQUA : message + ChatColor.GREEN) : (subserver.isAvailable() && subserver.isEnabled() && subserver.getCurrentIncompatibilities().size() == 0 ? message + ChatColor.YELLOW : message + ChatColor.RED);
                                        message = message + subserver.getDisplayName() + " [" + (subserver.getName().equals(subserver.getDisplayName()) ? "" : subserver.getName() + ChatColor.stripColor((String)div)) + subserver.getAddress().getPort() + "]";
                                        ++i;
                                    }
                                    if (i == 0) {
                                        message = message + this.plugin.api.getLang("SubServers", "Command.List.Empty");
                                    }
                                    sender.sendMessage(message);
                                    i = 0;
                                    sent = true;
                                }
                                if (!sent) {
                                    sender.sendMessage("  " + this.plugin.api.getLang("SubServers", "Command.List.Empty"));
                                }
                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.List.Server-Header"));
                                String message2 = "  ";
                                for (Server server : servers.values()) {
                                    if (server instanceof SubServer) continue;
                                    if (i != 0) {
                                        message2 = message2 + div;
                                    }
                                    message2 = message2 + ChatColor.WHITE + server.getDisplayName() + " [" + (server.getName().equals(server.getDisplayName()) ? "" : server.getName() + ChatColor.stripColor((String)div)) + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? server.getAddress().getAddress().getHostAddress() + ':' : "") + server.getAddress().getPort() + "]";
                                    ++i;
                                }
                                if (i == 0) {
                                    sender.sendMessage("  " + this.plugin.api.getLang("SubServers", "Command.List.Empty"));
                                } else {
                                    sender.sendMessage(message2);
                                }
                                if (proxies.keySet().size() > 0) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.List.Proxy-Header"));
                                    message2 = "  (master)";
                                    for (Proxy proxy : proxies.values()) {
                                        message2 = message2 + div;
                                        message2 = proxy.getSubData()[0] != null ? message2 + ChatColor.AQUA : message2 + ChatColor.RED;
                                        message2 = message2 + proxy.getDisplayName() + (proxy.getName().equals(proxy.getDisplayName()) ? "" : " [" + proxy.getName() + ']');
                                    }
                                    sender.sendMessage(message2);
                                }
                            }))));
                        }
                    } else if (args[0].equalsIgnoreCase("info") || args[0].equalsIgnoreCase("status")) {
                        if (args.length > 1) {
                            String type = args.length > 2 ? args[1] : null;
                            String name = args[type != null ? 2 : 1];
                            Runnable getPlayer = () -> this.plugin.api.getRemotePlayer(name, player -> {
                                if (player != null) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info").replace("$str$", "player") + ChatColor.WHITE + player.getName());
                                    if (player.getProxyName() != null) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Proxy") + ChatColor.WHITE + player.getProxyName());
                                    }
                                    if (player.getServerName() != null) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Server") + ChatColor.WHITE + player.getServerName());
                                    }
                                    if (player.getAddress() != null && this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Address") + ChatColor.WHITE + player.getAddress().getAddress().getHostAddress() + ':' + player.getAddress().getPort());
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "UUID") + ChatColor.AQUA + player.getUniqueId());
                                } else if (type == null) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown"));
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown-Player"));
                                }
                            });
                            Runnable getServer = () -> this.plugin.api.getServer(name, server -> {
                                if (server != null) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info").replace("$str$", (server instanceof SubServer ? "sub" : "") + "server") + ChatColor.WHITE + server.getDisplayName());
                                    if (!server.getName().equals(server.getDisplayName())) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "System Name") + ChatColor.WHITE + server.getName());
                                    }
                                    if (server instanceof SubServer) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Available") + (((SubServer)server).isAvailable() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Enabled") + (((SubServer)server).isEnabled() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                        if (!((SubServer)server).isEditable()) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Editable") + ChatColor.RED + "no");
                                        }
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Host") + ChatColor.WHITE + ((SubServer)server).getHost());
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Template") + ChatColor.WHITE + ((SubServer)server).getTemplate());
                                    }
                                    if (server.getGroups().size() > 0) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Group" + (server.getGroups().size() > 1 ? "s" : "")) + (server.getGroups().size() > 1 ? "" : ChatColor.WHITE + (String)server.getGroups().get(0)));
                                    }
                                    if (server.getGroups().size() > 1) {
                                        for (String group : server.getGroups()) {
                                            sender.sendMessage("    " + this.plugin.api.getLang("SubServers", "Command.Info.List") + ChatColor.WHITE + group);
                                        }
                                    }
                                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Address") + ChatColor.WHITE + server.getAddress().getAddress().getHostAddress() + ':' + server.getAddress().getPort());
                                    } else {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Port") + ChatColor.AQUA.toString() + server.getAddress().getPort());
                                    }
                                    if (server instanceof SubServer) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", ((SubServer)server).isOnline() ? "Online" : "Running") + (((SubServer)server).isRunning() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    }
                                    if (!(server instanceof SubServer) || ((SubServer)server).isRunning()) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Connected") + (server.getSubData()[0] != null ? ChatColor.GREEN + "yes" + (server.getSubData().length > 1 ? ChatColor.AQUA + " +" + (server.getSubData().length - 1) + " subchannel" + (server.getSubData().length == 2 ? "" : "s") : "") : ChatColor.RED + "no"));
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Players") + ChatColor.AQUA + server.getRemotePlayers().size() + " online");
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "MOTD") + ChatColor.WHITE + ChatColor.stripColor((String)server.getMotd()));
                                    if (server instanceof SubServer) {
                                        if (((SubServer)server).getStopAction() != SubServer.StopAction.NONE) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Stop Action") + ChatColor.WHITE + ((SubServer)server).getStopAction().toString());
                                        }
                                        if (((SubServer)server).isStopping()) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Stopping") + ChatColor.GREEN + "yes");
                                        }
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Signature") + ChatColor.AQUA + server.getSignature());
                                    if (server instanceof SubServer) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Logging") + (((SubServer)server).isLogging() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Restricted") + (server.isRestricted() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    if (server instanceof SubServer && ((SubServer)server).getIncompatibilities().size() > 0) {
                                        ArrayList<String> current = new ArrayList<String>();
                                        for (String other : ((SubServer)server).getCurrentIncompatibilities()) {
                                            current.add(other.toLowerCase());
                                        }
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Incompatibilities"));
                                        for (String other : ((SubServer)server).getIncompatibilities()) {
                                            sender.sendMessage("    " + this.plugin.api.getLang("SubServers", "Command.Info.List") + (current.contains(other.toLowerCase()) ? ChatColor.WHITE : ChatColor.GRAY) + other);
                                        }
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Hidden") + (server.isHidden() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                } else if (type == null) {
                                    getPlayer.run();
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown-Server"));
                                }
                            });
                            Runnable getGroup = () -> this.plugin.api.getGroup(name, group -> {
                                if (group != null) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info").replace("$str$", "group") + ChatColor.WHITE + (String)group.key());
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Servers") + (((List)group.value()).size() <= 0 ? ChatColor.GRAY + "(none)" : ChatColor.AQUA.toString() + ((List)group.value()).size()));
                                    for (Server server : (List)group.value()) {
                                        sender.sendMessage("    " + this.plugin.api.getLang("SubServers", "Command.Info.List") + ChatColor.WHITE + server.getDisplayName() + (server.getName().equals(server.getDisplayName()) ? "" : " [" + server.getName() + ']'));
                                    }
                                } else if (type == null) {
                                    getServer.run();
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown-Group"));
                                }
                            });
                            Runnable getHost = () -> this.plugin.api.getHost(name, host -> {
                                if (host != null) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info").replace("$str$", "host") + ChatColor.WHITE + host.getDisplayName());
                                    if (!host.getName().equals(host.getDisplayName())) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "System Name") + ChatColor.WHITE + host.getName());
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Available") + (host.isAvailable() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Enabled") + (host.isEnabled() ? ChatColor.GREEN + "yes" : ChatColor.RED + "no"));
                                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Address") + ChatColor.WHITE + host.getAddress().getHostAddress());
                                    }
                                    if (host.getSubData().length > 0) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Connected") + (host.getSubData()[0] != null ? ChatColor.GREEN + "yes" + (host.getSubData().length > 1 ? ChatColor.AQUA + " +" + (host.getSubData().length - 1) + " subchannel" + (host.getSubData().length == 2 ? "" : "s") : "") : ChatColor.RED + "no"));
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "SubServers") + (host.getSubServers().keySet().size() <= 0 ? ChatColor.GRAY + "(none)" : ChatColor.AQUA.toString() + host.getSubServers().keySet().size()));
                                    for (SubServer subserver : host.getSubServers().values()) {
                                        sender.sendMessage("    " + this.plugin.api.getLang("SubServers", "Command.Info.List") + (subserver.isEnabled() ? ChatColor.WHITE : ChatColor.GRAY) + subserver.getDisplayName() + (subserver.getName().equals(subserver.getDisplayName()) ? "" : " [" + subserver.getName() + ']'));
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Templates") + (host.getCreator().getTemplates().keySet().size() <= 0 ? ChatColor.GRAY + "(none)" : ChatColor.AQUA.toString() + host.getCreator().getTemplates().keySet().size()));
                                    for (SubCreator.ServerTemplate template : host.getCreator().getTemplates().values()) {
                                        sender.sendMessage("    " + this.plugin.api.getLang("SubServers", "Command.Info.List") + (template.isEnabled() ? ChatColor.WHITE : ChatColor.GRAY) + template.getDisplayName() + (template.getName().equals(template.getDisplayName()) ? "" : " [" + template.getName() + ']'));
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Signature") + ChatColor.AQUA + host.getSignature());
                                } else if (type == null) {
                                    getGroup.run();
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown-Host"));
                                }
                            });
                            Runnable getProxy = () -> this.plugin.api.getProxy(name, proxy -> {
                                if (proxy != null) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info").replace("$str$", "proxy") + ChatColor.WHITE + proxy.getDisplayName());
                                    if (!proxy.getName().equals(proxy.getDisplayName())) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "System Name") + ChatColor.WHITE + proxy.getName());
                                    }
                                    if (!proxy.isMaster()) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Connected") + (proxy.getSubData()[0] != null ? ChatColor.GREEN + "yes" + (proxy.getSubData().length > 1 ? ChatColor.AQUA + " +" + (proxy.getSubData().length - 1) + " subchannel" + (proxy.getSubData().length == 2 ? "" : "s") : "") : ChatColor.RED + "no"));
                                    } else if (!proxy.getDisplayName().toLowerCase().contains("master")) {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Type") + ChatColor.WHITE + "Master");
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Players") + ChatColor.AQUA + proxy.getPlayers().size() + " online");
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Format").replace("$str$", "Signature") + ChatColor.AQUA + proxy.getSignature());
                                } else if (type == null) {
                                    getHost.run();
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown-Proxy"));
                                }
                            });
                            if (type == null) {
                                getProxy.run();
                            } else {
                                switch (type.toLowerCase()) {
                                    case "p": 
                                    case "proxy": {
                                        getProxy.run();
                                        break;
                                    }
                                    case "h": 
                                    case "host": {
                                        getHost.run();
                                        break;
                                    }
                                    case "g": 
                                    case "group": {
                                        getGroup.run();
                                        break;
                                    }
                                    case "s": 
                                    case "server": 
                                    case "subserver": {
                                        getServer.run();
                                        break;
                                    }
                                    case "u": 
                                    case "user": 
                                    case "player": {
                                        getPlayer.run();
                                        break;
                                    }
                                    default: {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Info.Unknown-Type"));
                                    }
                                }
                            }
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " [proxy|host|group|server|player] <Name>"));
                        }
                    } else if (args[0].equalsIgnoreCase("start")) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, true, new String[]{"subservers.subserver.%.*", "subservers.subserver.%.start"}, (ServerSelection select) -> {
                                if (((ServerSelection)select).subservers.length > 0) {
                                    Container success = new Container((Object)0);
                                    Container running = new Container((Object)0);
                                    Merger merge = new Merger(() -> {
                                        if ((Integer)running.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Running").replace("$int$", ((Integer)running.value).toString()));
                                        }
                                        if ((Integer)success.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start").replace("$int$", ((Integer)success.value).toString()));
                                        }
                                    });
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        merge.reserve();
                                        server.start(sender instanceof Player ? ((Player)sender).getUniqueId() : null, response -> {
                                            switch (response) {
                                                case 3: 
                                                case 4: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Disappeared").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 5: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Host-Unavailable").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 6: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Host-Disabled").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 7: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Server-Unavailable").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 8: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Server-Disabled").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 9: {
                                                    Integer n = (Integer)running.value;
                                                    running.value = (Integer)running.value + 1;
                                                    break;
                                                }
                                                case 10: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Start.Server-Incompatible").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 0: {
                                                    Integer n = (Integer)success.value;
                                                    success.value = (Integer)success.value + 1;
                                                }
                                            }
                                            merge.release();
                                        });
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Subservers>"));
                        }
                    } else if (args[0].equalsIgnoreCase("restart")) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, true, new String[][]{{"subservers.subserver.%.*", "subservers.subserver.%.start"}, {"subservers.subserver.%.*", "subservers.subserver.%.stop"}}, (ServerSelection select) -> {
                                if (((ServerSelection)select).subservers.length > 0) {
                                    UUID player = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
                                    final Consumer<SubServer> starter = server -> server.start(player, response -> {
                                        switch (response) {
                                            case 3: 
                                            case 4: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Disappeared").replace("$str$", server.getName()));
                                                break;
                                            }
                                            case 5: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Host-Unavailable").replace("$str$", server.getName()));
                                                break;
                                            }
                                            case 6: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Host-Disabled").replace("$str$", server.getName()));
                                                break;
                                            }
                                            case 7: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Server-Unavailable").replace("$str$", server.getName()));
                                                break;
                                            }
                                            case 8: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Server-Disabled").replace("$str$", server.getName()));
                                                break;
                                            }
                                            case 10: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Server-Incompatible").replace("$str$", server.getName()));
                                                break;
                                            }
                                        }
                                    });
                                    final HashMap<String, SubServer> listening = new HashMap<String, SubServer>();
                                    PacketInExRunEvent.callback("SubStoppedEvent", new Consumer<ObjectMap<String>>(){

                                        @Override
                                        public void accept(ObjectMap<String> json) {
                                            try {
                                                if (listening.size() > 0) {
                                                    PacketInExRunEvent.callback("SubStoppedEvent", this);
                                                    String name = json.getString((Object)"server").toLowerCase();
                                                    if (listening.containsKey(name)) {
                                                        AgnosticScheduler.async.runs((Plugin)SubCommand.this.plugin, c -> {
                                                            starter.accept((SubServer)listening.get(name));
                                                            listening.remove(name);
                                                        }, 250L, TimeUnit.MILLISECONDS);
                                                    }
                                                }
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    });
                                    Container success = new Container((Object)0);
                                    Merger merge = new Merger(() -> {
                                        if ((Integer)success.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart").replace("$int$", ((Integer)success.value).toString()));
                                        }
                                    });
                                    Consumer<Pair> stopper = data -> {
                                        if ((Integer)data.key() != 0) {
                                            listening.remove(((SubServer)data.value()).getName().toLowerCase());
                                        }
                                        switch ((Integer)data.key()) {
                                            case 3: 
                                            case 4: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Restart.Disappeared").replace("$str$", ((SubServer)data.value()).getName()));
                                                break;
                                            }
                                            case 5: {
                                                starter.accept((SubServer)data.value());
                                            }
                                            case 0: {
                                                Integer n = (Integer)success.value;
                                                success.value = (Integer)success.value + 1;
                                            }
                                        }
                                        merge.release();
                                    };
                                    SubServer self = null;
                                    for (SubServer server2 : ((ServerSelection)select).subservers) {
                                        if (!server2.getName().equalsIgnoreCase(this.plugin.api.getName())) continue;
                                        self = server2;
                                        break;
                                    }
                                    for (SubServer server2 : ((ServerSelection)select).subservers) {
                                        merge.reserve();
                                        if (self == null) {
                                            listening.put(server2.getName().toLowerCase(), server2);
                                            server2.stop(player, response -> stopper.accept((Pair)new ContainedPair((Object)response, (Object)server2)));
                                            continue;
                                        }
                                        if (self == server2) continue;
                                        ((SubDataClient)this.plugin.api.getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketRestartServer(player, server2.getName(), new Consumer[]{data -> stopper.accept((Pair)new ContainedPair((Object)data.getInt((Object)1), (Object)server2))})});
                                    }
                                    if (self != null) {
                                        SubServer fself = self;
                                        ((SubDataClient)this.plugin.api.getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketRestartServer(player, self.getName(), new Consumer[]{data -> stopper.accept((Pair)new ContainedPair((Object)data.getInt((Object)1), (Object)fself))})});
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Subservers>"));
                        }
                    } else if (args[0].equalsIgnoreCase("stop")) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, true, new String[]{"subservers.subserver.%.*", "subservers.subserver.%.stop"}, (ServerSelection select) -> {
                                if (((ServerSelection)select).subservers.length > 0) {
                                    Container success = new Container((Object)0);
                                    Container running = new Container((Object)0);
                                    Merger merge = new Merger(() -> {
                                        if ((Integer)running.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Stop.Not-Running").replace("$int$", ((Integer)running.value).toString()));
                                        }
                                        if ((Integer)success.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Stop").replace("$int$", ((Integer)success.value).toString()));
                                        }
                                    });
                                    Consumer<Pair> stopper = data -> {
                                        switch ((Integer)data.key()) {
                                            case 3: 
                                            case 4: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Stop.Disappeared").replace("$str$", ((SubServer)data.value()).getName()));
                                                break;
                                            }
                                            case 5: {
                                                Integer n = (Integer)running.value;
                                                running.value = (Integer)running.value + 1;
                                                break;
                                            }
                                            case 0: {
                                                Integer n = (Integer)success.value;
                                                success.value = (Integer)success.value + 1;
                                            }
                                        }
                                        merge.release();
                                    };
                                    SubServer self = null;
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        if (!server.getName().equalsIgnoreCase(this.plugin.api.getName())) continue;
                                        self = server;
                                        break;
                                    }
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        merge.reserve();
                                        if (self == server) continue;
                                        server.stop(sender instanceof Player ? ((Player)sender).getUniqueId() : null, response -> stopper.accept((Pair)new ContainedPair((Object)response, (Object)server)));
                                    }
                                    if (self != null) {
                                        SubServer fself = self;
                                        fself.stop(sender instanceof Player ? ((Player)sender).getUniqueId() : null, response -> stopper.accept((Pair)new ContainedPair((Object)response, (Object)fself)));
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Subservers>"));
                        }
                    } else if (args[0].equalsIgnoreCase("kill") || args[0].equalsIgnoreCase("terminate")) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, true, new String[]{"subservers.subserver.%.*", "subservers.subserver.%.terminate"}, (ServerSelection select) -> {
                                if (((ServerSelection)select).subservers.length > 0) {
                                    Container success = new Container((Object)0);
                                    Container running = new Container((Object)0);
                                    Merger merge = new Merger(() -> {
                                        if ((Integer)running.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Terminate.Not-Running").replace("$int$", ((Integer)running.value).toString()));
                                        }
                                        if ((Integer)success.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Terminate").replace("$int$", ((Integer)success.value).toString()));
                                        }
                                    });
                                    Consumer<Pair> stopper = data -> {
                                        switch ((Integer)data.key()) {
                                            case 3: 
                                            case 4: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Terminate.Disappeared").replace("$str$", ((SubServer)data.value()).getName()));
                                                break;
                                            }
                                            case 5: {
                                                Integer n = (Integer)running.value;
                                                running.value = (Integer)running.value + 1;
                                                break;
                                            }
                                            case 0: {
                                                Integer n = (Integer)success.value;
                                                success.value = (Integer)success.value + 1;
                                            }
                                        }
                                        merge.release();
                                    };
                                    SubServer self = null;
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        if (!server.getName().equalsIgnoreCase(this.plugin.api.getName())) continue;
                                        self = server;
                                        break;
                                    }
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        merge.reserve();
                                        if (self == server) continue;
                                        server.terminate(sender instanceof Player ? ((Player)sender).getUniqueId() : null, response -> stopper.accept((Pair)new ContainedPair((Object)response, (Object)server)));
                                    }
                                    if (self != null) {
                                        SubServer fself = self;
                                        fself.terminate(sender instanceof Player ? ((Player)sender).getUniqueId() : null, response -> stopper.accept((Pair)new ContainedPair((Object)response, (Object)fself)));
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Subservers>"));
                        }
                    } else if (args[0].equalsIgnoreCase("cmd") || args[0].equalsIgnoreCase("command")) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, false, new String[]{"subservers.subserver.%.*", "subservers.subserver.%.command"}, (ServerSelection select) -> {
                                if (((ServerSelection)select).servers.length > 0) {
                                    if (((ServerSelection)select).args.length > 2) {
                                        StringBuilder builder = new StringBuilder(((ServerSelection)select).args[2]);
                                        for (int i = 3; i < ((ServerSelection)select).args.length; ++i) {
                                            builder.append(' ');
                                            builder.append(((ServerSelection)select).args[i]);
                                        }
                                        Container success = new Container((Object)0);
                                        Container running = new Container((Object)0);
                                        Merger merge = new Merger(() -> {
                                            if ((Integer)running.value > 0) {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Command.Not-Running").replace("$int$", ((Integer)running.value).toString()));
                                            }
                                            if ((Integer)success.value > 0) {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Command").replace("$int$", ((Integer)success.value).toString()));
                                            }
                                        });
                                        for (Server server : ((ServerSelection)select).servers) {
                                            merge.reserve();
                                            server.command(sender instanceof Player ? ((Player)sender).getUniqueId() : null, builder.toString(), response -> {
                                                switch (response) {
                                                    case 3: 
                                                    case 4: {
                                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Command.Disappeared").replace("$str$", server.getName()));
                                                        break;
                                                    }
                                                    case 5: {
                                                        Integer n = (Integer)running.value;
                                                        running.value = (Integer)running.value + 1;
                                                        break;
                                                    }
                                                    case 0: {
                                                        Integer n = (Integer)success.value;
                                                        success.value = (Integer)success.value + 1;
                                                    }
                                                }
                                                merge.release();
                                            });
                                        }
                                    } else {
                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Command.No-Command"));
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Servers> <Command> [Args...]"));
                        }
                    } else if (args[0].equalsIgnoreCase("create")) {
                        if (args.length > 3) {
                            if (ObjectPermission.permits(args[2], (Permissible)sender, "subservers.host.%.*", "subservers.host.%.create")) {
                                if (args.length > 5 && !Try.all.run(() -> Integer.parseInt(args[5]))) {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Invalid-Port"));
                                } else {
                                    ((SubDataClient)this.plugin.api.getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketCreateServer(sender instanceof Player ? ((Player)sender).getUniqueId() : null, args[1], args[2], args[3], args.length > 4 ? new Version(args[4]) : null, args.length > 5 ? Integer.valueOf(Integer.parseInt(args[5])) : null, new Consumer[]{data -> {
                                        switch (data.getInt((Object)1)) {
                                            case 3: 
                                            case 4: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Exists"));
                                                break;
                                            }
                                            case 5: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Unknown-Host"));
                                                break;
                                            }
                                            case 6: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Host-Unavailable"));
                                                break;
                                            }
                                            case 7: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Host-Disabled"));
                                                break;
                                            }
                                            case 8: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Unknown-Template"));
                                                break;
                                            }
                                            case 9: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Template-Disabled"));
                                                break;
                                            }
                                            case 10: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Version-Required"));
                                                break;
                                            }
                                            case 11: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Invalid-Port"));
                                                break;
                                            }
                                            case 0: {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator").replace("$str$", args[1]));
                                            }
                                        }
                                    }})});
                                }
                            } else {
                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Permission").replace("$str$", "subservers.host." + args[2].toLowerCase() + ".create"));
                            }
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Name> <Host> <Template> [Version] [Port]"));
                        }
                    } else if (args[0].equalsIgnoreCase("update") || args[0].equalsIgnoreCase("upgrade")) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, true, new String[]{"subservers.subserver.%.*", "subservers.subserver.%.update"}, (ServerSelection select) -> {
                                if (((ServerSelection)select).subservers.length > 0) {
                                    String template;
                                    String string = template = ((ServerSelection)select).args.length > 3 ? ((ServerSelection)select).args[2].toLowerCase() : null;
                                    Version version = ((ServerSelection)select).args.length > 2 ? new Version(((ServerSelection)select).args[template == null ? 2 : 3]) : null;
                                    boolean ts = template == null;
                                    Container success = new Container((Object)0);
                                    Merger merge = new Merger(() -> {
                                        if ((Integer)success.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update").replace("$int$", ((Integer)success.value).toString()));
                                        }
                                    });
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        merge.reserve();
                                        ((SubDataClient)this.plugin.api.getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketUpdateServer(sender instanceof Player ? ((Player)sender).getUniqueId() : null, server.getName(), template, version, new Consumer[]{data -> {
                                            switch (data.getInt((Object)1)) {
                                                case 3: 
                                                case 4: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Disappeared").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 5: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Host-Unavailable").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 6: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Host-Disabled").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 7: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Server-Unavailable").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 8: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Running").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 9: {
                                                    if (ts) {
                                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Unknown-Template").replace("$str$", server.getName()));
                                                        break;
                                                    }
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Unknown-Template"));
                                                    break;
                                                }
                                                case 10: {
                                                    if (ts) {
                                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Template-Disabled").replace("$str$", server.getName()));
                                                        break;
                                                    }
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Template-Disabled"));
                                                    break;
                                                }
                                                case 11: {
                                                    if (ts) {
                                                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Template-Invalid").replace("$str$", server.getName()));
                                                        break;
                                                    }
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Creator.Template-Invalid"));
                                                    break;
                                                }
                                                case 12: {
                                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Update.Version-Required").replace("$str$", server.getName()));
                                                    break;
                                                }
                                                case 0: {
                                                    Integer n = (Integer)success.value;
                                                    success.value = (Integer)success.value + 1;
                                                }
                                            }
                                            merge.release();
                                        }})});
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " <Subservers> [[Template] <Version>]"));
                        }
                    } else if ((args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("del") || args[0].equalsIgnoreCase("delete")) && this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Allow-Deletion", Boolean.valueOf(false)).booleanValue()) {
                        if (args.length > 1) {
                            this.selectServers(sender, args, 1, true, "subservers.subserver.%.delete", (ServerSelection select) -> {
                                if (((ServerSelection)select).subservers.length > 0) {
                                    Container success = new Container((Object)0);
                                    Merger merge = new Merger(() -> {
                                        if ((Integer)success.value > 0) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Delete").replace("$int$", ((Integer)success.value).toString()));
                                        }
                                    });
                                    for (SubServer server : ((ServerSelection)select).subservers) {
                                        if (server.isRunning()) {
                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Delete.Running").replace("$str$", server.getName()));
                                            continue;
                                        }
                                        server.getHost(host -> {
                                            if (host == null) {
                                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Delete.Disappeared").replace("$str$", server.getName()));
                                            } else {
                                                merge.reserve();
                                                host.recycleSubServer(server.getName(), response -> {
                                                    switch (response) {
                                                        case 3: 
                                                        case 4: {
                                                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Delete.Disappeared").replace("$str$", server.getName()));
                                                            break;
                                                        }
                                                        case 0: {
                                                            Integer n = (Integer)success.value;
                                                            success.value = (Integer)success.value + 1;
                                                        }
                                                    }
                                                    merge.release();
                                                });
                                            }
                                        });
                                    }
                                }
                            });
                        } else {
                            sender.sendMessage("Usage: " + label + " " + args[0].toLowerCase() + " <Subservers>");
                        }
                    } else if (!args[0].equalsIgnoreCase("restore")) {
                        if (args[0].equalsIgnoreCase("tp") || args[0].equalsIgnoreCase("teleport")) {
                            this.executeTeleport(sender, label, args);
                        } else if ((args[0].equalsIgnoreCase("view") || args[0].equalsIgnoreCase("open")) && sender instanceof Player) {
                            if (this.plugin.gui != null) {
                                if (sender.hasPermission("subservers.interface")) {
                                    try {
                                        this.plugin.gui.getRenderer((Player)sender).clearHistory();
                                        switch (args[1].toLowerCase()) {
                                            case "host": {
                                                if (args.length > 2) {
                                                    this.plugin.gui.getRenderer((Player)sender).hostMenu(Integer.parseInt(args[2]));
                                                    break;
                                                }
                                                this.plugin.gui.getRenderer((Player)sender).hostMenu(1);
                                                break;
                                            }
                                            case "host/": {
                                                this.plugin.gui.getRenderer((Player)sender).hostAdmin(args[2]);
                                                break;
                                            }
                                            case "host/creator": {
                                                if (ObjectPermission.permits(args[2], (Permissible)sender, "subservers.host.%.*", "subservers.host.%.create")) {
                                                    this.plugin.gui.getRenderer((Player)sender).hostCreator(new UIRenderer.CreatorOptions(args[2]));
                                                    break;
                                                }
                                                throw new IllegalStateException("Player does not meet the requirements to render this page");
                                            }
                                            case "host/plugin": {
                                                if (args.length > 3) {
                                                    this.plugin.gui.getRenderer((Player)sender).hostPlugin(Integer.parseInt(args[3]), args[2]);
                                                    break;
                                                }
                                                this.plugin.gui.getRenderer((Player)sender).hostPlugin(1, args[2]);
                                                break;
                                            }
                                            case "group": {
                                                if (args.length > 2) {
                                                    this.plugin.gui.getRenderer((Player)sender).groupMenu(Integer.parseInt(args[2]));
                                                    break;
                                                }
                                                this.plugin.gui.getRenderer((Player)sender).groupMenu(1);
                                                break;
                                            }
                                            case "server": 
                                            case "subserver": {
                                                if (args.length > 4) {
                                                    this.plugin.gui.getRenderer((Player)sender).serverMenu(Integer.parseInt(args[2]), args[4], null);
                                                    break;
                                                }
                                                if (args.length > 3) {
                                                    this.plugin.gui.getRenderer((Player)sender).serverMenu(Integer.parseInt(args[2]), null, args[3]);
                                                    break;
                                                }
                                                if (args.length > 2) {
                                                    this.plugin.gui.getRenderer((Player)sender).serverMenu(Integer.parseInt(args[2]), null, null);
                                                    break;
                                                }
                                                this.plugin.gui.getRenderer((Player)sender).serverMenu(1, null, null);
                                                break;
                                            }
                                            case "server/": 
                                            case "subserver/": {
                                                this.plugin.gui.getRenderer((Player)sender).serverAdmin(args[2]);
                                                break;
                                            }
                                            case "server/plugin": 
                                            case "subserver/plugin": {
                                                if (args.length > 3) {
                                                    this.plugin.gui.getRenderer((Player)sender).serverPlugin(Integer.parseInt(args[3]), args[2]);
                                                    break;
                                                }
                                                this.plugin.gui.getRenderer((Player)sender).serverPlugin(1, args[2]);
                                            }
                                        }
                                    }
                                    catch (Throwable throwable) {}
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Permission").replace("$str$", "subservers.interface"));
                                }
                            }
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Subcommand").replace("$str$", args[0]));
                        }
                    }
                } else if (this.plugin.gui != null && sender instanceof Player && sender.hasPermission("subservers.interface")) {
                    this.plugin.gui.getRenderer((Player)sender).newUI();
                } else {
                    sender.sendMessage(this.printHelp(label));
                }
            } else if (args.length > 0 && (args[0].equalsIgnoreCase("tp") || args[0].equalsIgnoreCase("teleport"))) {
                this.executeTeleport(sender, label, args);
            } else if (this.plugin.gui != null && sender instanceof Player && sender.hasPermission("subservers.interface")) {
                this.plugin.gui.getRenderer((Player)sender).newUI();
            } else {
                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Permission").replace("$str$", "subservers.command"));
            }
        }
        return true;
    }

    private void executeTeleport(CommandSender sender, String label, String[] args) {
        if (args.length > (sender instanceof Player ? 1 : 2)) {
            if (sender.hasPermission("subservers.teleport")) {
                String select = args[args.length > 2 ? 2 : 1];
                this.plugin.api.getServer(select, server -> {
                    if (server != null) {
                        if (!(server instanceof SubServer) || ((SubServer)server).isRunning()) {
                            Player target;
                            Player player = target = args.length > 2 ? Bukkit.getPlayer((String)args[1]) : null;
                            if (target != null || args.length == 2) {
                                if (target == null || target == sender || sender.hasPermission("subservers.teleport-others")) {
                                    if (target == null) {
                                        target = (Player)sender;
                                    }
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", target == sender ? "Command.Teleport" : "Command.Teleport.Others").replace("$name$", target.getName()).replace("$str$", server.getDisplayName()));
                                    this.plugin.pmc(target, "Connect", server.getName());
                                } else {
                                    sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Permission").replace("$str$", "subservers.teleport-others"));
                                }
                            } else {
                                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Unknown-Player").replace("$str$", args[1]));
                            }
                        } else {
                            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Teleport.Not-Running").replace("$str$", server.getName()));
                        }
                    } else {
                        sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Unknown-Server").replace("$str$", select));
                    }
                });
            } else {
                sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Permission").replace("$str$", "subservers.teleport"));
            }
        } else {
            sender.sendMessage(this.plugin.api.getLang("SubServers", "Command.Generic.Usage").replace("$str$", label.toLowerCase() + " " + args[0].toLowerCase() + " " + (sender instanceof Player ? "[Player]" : "<Player>") + " <Server>"));
        }
    }

    private void selectServers(CommandSender sender, String[] rargs, int index, boolean mode, String permissions, Consumer<ServerSelection> callback) {
        this.selectServers(sender, rargs, index, mode, new String[]{permissions}, callback);
    }

    private void selectServers(CommandSender sender, String[] rargs, int index, boolean mode, String[] permissions, Consumer<ServerSelection> callback) {
        this.selectServers(sender, rargs, index, mode, new String[][]{permissions}, callback);
    }

    private void selectServers(CommandSender sender, String[] rargs, int index, boolean mode, String[][] permissions, Consumer<ServerSelection> callback) {
        StackTraceElement[] origin = new Throwable().getStackTrace();
        LinkedList msgs = new LinkedList();
        LinkedList<String> args = new LinkedList<String>();
        LinkedList<String> selection = new LinkedList<String>();
        LinkedList select = new LinkedList();
        Container last = new Container(null);
        Container ic = new Container((Object)0);
        while ((Integer)ic.value() < index) {
            args.add(rargs[(Integer)ic.value()]);
            ic.value((Object)((Integer)ic.value() + 1));
        }
        StringBuilder completed = new StringBuilder();
        Runnable finished = () -> this.lambda$selectServers$50(args, completed, (Value)ic, rargs, (Value)last, select, sender, permissions, msgs, mode, callback, selection, origin);
        Merger merge = new Merger(finished);
        boolean run = true;
        while (run && (Integer)ic.value() < rargs.length) {
            String current = rargs[(Integer)ic.value()];
            last.value((Object)current);
            completed.append(current);
            if (current.endsWith(",")) {
                current = current.substring(0, current.length() - 1);
                completed.append(' ');
            } else {
                run = false;
            }
            selection.add(current.toLowerCase());
            if (current.length() > 0) {
                String fcurrent;
                merge.reserve();
                if (current.startsWith("::") && current.length() > 2) {
                    if ((current = current.substring(2)).equals(".")) {
                        this.plugin.api.getSubServer(this.plugin.api.getName(), self -> {
                            if (self != null) {
                                merge.reserve();
                                self.getHost(host -> {
                                    select.addAll(host.getSubServers().values());
                                    merge.release();
                                });
                            } else {
                                String msg = this.plugin.api.getLang("SubServers", "Command.Generic.Unknown-SubServer").replace("$str$", this.plugin.api.getName());
                                if (sender != null) {
                                    sender.sendMessage(msg);
                                }
                                msgs.add(msg);
                            }
                            merge.release();
                        });
                    } else if (current.equals("*")) {
                        this.plugin.api.getHosts(hostMap -> {
                            for (Host host : hostMap.values()) {
                                select.addAll(host.getSubServers().values());
                            }
                            merge.release();
                        });
                    } else {
                        fcurrent = current;
                        this.plugin.api.getHost(current, host -> {
                            if (host != null) {
                                if (!select.addAll(host.getSubServers().values())) {
                                    String msg = this.plugin.api.getLang("SubServers", "Command.Generic.No-" + (mode ? "Sub" : "") + "Servers-On-Host").replace("$str$", host.getName());
                                    if (sender != null) {
                                        sender.sendMessage(msg);
                                    }
                                    msgs.add(msg);
                                }
                            } else {
                                String msg = this.plugin.api.getLang("SubServers", "Command.Generic.Unknown-Host").replace("$str$", fcurrent);
                                if (sender != null) {
                                    sender.sendMessage(msg);
                                }
                                msgs.add(msg);
                            }
                            merge.release();
                        });
                    }
                } else if (current.startsWith(":") && current.length() > 1) {
                    if ((current = current.substring(1)).equals(".")) {
                        this.plugin.api.getSubServer(this.plugin.api.getName(), self -> {
                            Merger merge2 = new Merger(() -> ((Merger)merge).release());
                            for (String name : self.getGroups()) {
                                merge2.reserve();
                                this.plugin.api.getGroup(name, group -> {
                                    for (Server server : (List)group.value()) {
                                        if (mode && !(server instanceof SubServer)) continue;
                                        select.add(server);
                                    }
                                    merge2.release();
                                });
                            }
                        });
                    } else if (current.equals("*")) {
                        this.plugin.api.getGroups(groupMap -> {
                            for (List group : groupMap.values()) {
                                for (Server server : group) {
                                    if (mode && !(server instanceof SubServer)) continue;
                                    select.add(server);
                                }
                            }
                            merge.release();
                        });
                    } else {
                        fcurrent = current;
                        this.plugin.api.getGroup(current, group -> {
                            if (group != null) {
                                int i = 0;
                                for (Server server : (List)group.value()) {
                                    if (mode && !(server instanceof SubServer)) continue;
                                    select.add(server);
                                    ++i;
                                }
                                if (i <= 0) {
                                    String msg = this.plugin.api.getLang("SubServers", "Command.Generic.No-" + (mode ? "Sub" : "") + "Servers-In-Group").replace("$str$", (CharSequence)group.key());
                                    if (sender != null) {
                                        sender.sendMessage(msg);
                                    }
                                    msgs.add(msg);
                                }
                            } else {
                                String msg = this.plugin.api.getLang("SubServers", "Command.Generic.Unknown-Group").replace("$str$", fcurrent);
                                if (sender != null) {
                                    sender.sendMessage(msg);
                                }
                                msgs.add(msg);
                            }
                            merge.release();
                        });
                    }
                } else if (current.equals(".")) {
                    this.plugin.api.getServer(this.plugin.api.getName(), self -> {
                        if (!mode || self instanceof SubServer) {
                            select.add(self);
                        }
                        merge.release();
                    });
                } else if (current.equals("*")) {
                    this.plugin.api.getServers(serverMap -> {
                        for (Server server : serverMap.values()) {
                            if (mode && !(server instanceof SubServer)) continue;
                            select.add(server);
                        }
                        merge.release();
                    });
                } else {
                    fcurrent = current;
                    this.plugin.api.getServer(current, server -> {
                        if (server != null) {
                            select.add(server);
                        } else {
                            String msg = this.plugin.api.getLang("SubServers", "Command.Generic.Unknown-" + (mode ? "Sub" : "") + "Server").replace("$str$", fcurrent);
                            if (sender != null) {
                                sender.sendMessage(msg);
                            }
                            msgs.add(msg);
                        }
                        merge.release();
                    });
                }
            }
            ic.value((Object)((Integer)ic.value() + 1));
        }
    }

    private String[] printHelp(String label) {
        return new String[]{this.plugin.api.getLang("SubServers", "Command.Help.Header"), this.plugin.api.getLang("SubServers", "Command.Help.Help").replace("$str$", label.toLowerCase() + " help"), this.plugin.api.getLang("SubServers", "Command.Help.List").replace("$str$", label.toLowerCase() + " list"), this.plugin.api.getLang("SubServers", "Command.Help.Version").replace("$str$", label.toLowerCase() + " version"), this.plugin.api.getLang("SubServers", "Command.Help.Info").replace("$str$", label.toLowerCase() + " info [proxy|host|group|server|player] <Name>"), this.plugin.api.getLang("SubServers", "Command.Help.SubServer.Start").replace("$str$", label.toLowerCase() + " start <Subservers>"), this.plugin.api.getLang("SubServers", "Command.Help.SubServer.Restart").replace("$str$", label.toLowerCase() + " restart <Subservers>"), this.plugin.api.getLang("SubServers", "Command.Help.SubServer.Stop").replace("$str$", label.toLowerCase() + " stop <Subservers>"), this.plugin.api.getLang("SubServers", "Command.Help.SubServer.Terminate").replace("$str$", label.toLowerCase() + " kill <Subservers>"), this.plugin.api.getLang("SubServers", "Command.Help.SubServer.Command").replace("$str$", label.toLowerCase() + " cmd <Servers> <Command> [Args...]"), this.plugin.api.getLang("SubServers", "Command.Help.Host.Create").replace("$str$", label.toLowerCase() + " create <Name> <Host> <Template> [Version] [Port]"), this.plugin.api.getLang("SubServers", "Command.Help.SubServer.Update").replace("$str$", label.toLowerCase() + " update <Subservers> [[Template] <Version>]")};
    }

    private /* synthetic */ void lambda$selectServers$50(LinkedList args, StringBuilder completed, Value ic, String[] rargs, Value last, LinkedList select, CommandSender sender, String[][] permissions, LinkedList msgs, boolean mode, Consumer callback, LinkedList selection, StackTraceElement[] origin) {
        args.add(completed.toString());
        for (int i = ((Integer)ic.value()).intValue(); i < rargs.length; ++i) {
            args.add(rargs[i]);
            last.value(null);
        }
        LinkedList<Server> history = new LinkedList<Server>();
        LinkedList<Server> servers = new LinkedList<Server>();
        LinkedList<SubServer> subservers = new LinkedList<SubServer>();
        for (Server server : select) {
            boolean permitted;
            if (history.contains(server)) continue;
            history.add(server);
            boolean bl = permitted = sender == null || permissions == null || permissions.length == 0;
            if (!permitted) {
                permitted = true;
                for (int p = 0; permitted && p < permissions.length; ++p) {
                    if (permissions[p] == null || permissions[p].length == 0) continue;
                    permitted = ObjectPermission.permits(server, (Permissible)sender, permissions[p]);
                }
            }
            if (permitted) {
                servers.add(server);
                if (!(server instanceof SubServer)) continue;
                subservers.add((SubServer)server);
                continue;
            }
            String msg = this.plugin.api.getLang("SubServers", "Command.Generic.Invalid-Select-Permission").replace("$str$", server.getName());
            sender.sendMessage(msg);
            msgs.add(msg);
        }
        if (!mode && servers.size() <= 0 || mode && subservers.size() <= 0) {
            String msg = this.plugin.api.getLang("SubServers", "Command.Generic.No-" + (mode ? "Sub" : "") + "Servers-Selected");
            if (sender != null) {
                sender.sendMessage(msg);
            }
            msgs.add(msg);
        }
        try {
            callback.accept(new ServerSelection(msgs, selection, servers, subservers, args, (String)last.value()));
        }
        catch (Throwable e) {
            InvocationTargetException ew = new InvocationTargetException(e);
            ew.setStackTrace(origin);
            ew.printStackTrace();
        }
    }

    private static final class ServerSelection {
        private final String[] msgs;
        private final String[] selection;
        private final Server[] servers;
        private final SubServer[] subservers;
        private final String[] args;
        private final String last;

        private ServerSelection(List<String> msgs, List<String> selection, List<Server> servers, List<SubServer> subservers, List<String> args, String last) {
            this.msgs = msgs.toArray(new String[0]);
            this.selection = selection.toArray(new String[0]);
            this.servers = servers.toArray(new Server[0]);
            this.subservers = subservers.toArray(new SubServer[0]);
            this.args = args.toArray(new String[0]);
            this.last = last;
            Arrays.sort(this.selection);
        }
    }
}

