/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.ME1312.Galaxi.Library.Config.YAMLConfig;
import net.ME1312.Galaxi.Library.Config.YAMLSection;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.Cipher;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.Encryption.AES;
import net.ME1312.SubData.Client.Encryption.DHE;
import net.ME1312.SubData.Client.Encryption.RSA;
import net.ME1312.SubData.Client.Library.DisconnectReason;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Bukkit.Graphic.DefaultUIHandler;
import net.ME1312.SubServers.Client.Bukkit.Graphic.UIHandler;
import net.ME1312.SubServers.Client.Bukkit.Library.AccessMode;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.AgnosticScheduler;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.PlaceholderImpl;
import net.ME1312.SubServers.Client.Bukkit.Library.ConfigUpdater;
import net.ME1312.SubServers.Client.Bukkit.Library.Metrics;
import net.ME1312.SubServers.Client.Bukkit.Library.Placeholders;
import net.ME1312.SubServers.Client.Bukkit.Network.SubProtocol;
import net.ME1312.SubServers.Client.Bukkit.SubAPI;
import net.ME1312.SubServers.Client.Bukkit.SubCommand;
import net.ME1312.SubServers.Client.Bukkit.SubSigns;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;

public final class SubPlugin
extends JavaPlugin {
    HashMap<Integer, SubDataClient> subdata = new HashMap();
    Pair<Long, Map<String, Map<String, String>>> lang = null;
    private File dir;
    public YAMLConfig config;
    public SubProtocol subprotocol;
    public UIHandler gui = null;
    public SubSigns signs = null;
    public final Version version;
    public final SubAPI api = new SubAPI(this);
    public final Placeholders phi = new Placeholders(this);
    public String server_address;
    private MethodHandle gson;
    private long resetDate = 0L;
    private boolean reconnect = false;

    public SubPlugin() throws Throwable {
        Class<?> gson = Class.forName(((Boolean)Try.all.get(() -> Class.forName("com.google.gson.Gson") != null, (Object)false) != false ? "" : "org.bukkit.craftbukkit.libs.") + "com.google.gson.Gson");
        this.gson = MethodHandles.publicLookup().findVirtual(gson, "fromJson", MethodType.methodType(Object.class, new Class[]{String.class, Class.class})).bindTo(gson.newInstance());
        this.version = Version.fromString((String)this.getDescription().getVersion());
        this.subdata.put(0, null);
    }

    public void onEnable() {
        try {
            Bukkit.getLogger().info("SubServers > Loading SubServers.Client.Bukkit v" + this.version.toString() + " Libraries (for Minecraft " + this.api.getGameVersion() + ")");
            this.dir = new File(this.getDataFolder().getParentFile(), "SubServers-Client");
            if (this.getDataFolder().exists()) {
                Files.move(this.getDataFolder().toPath(), this.dir.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                this.dir.mkdirs();
            }
            ConfigUpdater.updateConfig(new File(this.dir, "config.yml"));
            this.config = new YAMLConfig(new File(this.dir, "config.yml"));
            if (new File(new File(System.getProperty("user.dir")), "subdata.json").exists()) {
                FileReader reader = new FileReader(new File(new File(System.getProperty("user.dir")), "subdata.json"));
                this.config.get().getMap((Object)"Settings").set((Object)"SubData", (Object)new YAMLSection(this.parseJSON(Util.readAll((Reader)reader))));
                this.config.save();
                reader.close();
                new File(new File(System.getProperty("user.dir")), "subdata.json").delete();
            }
            if (new File(new File(System.getProperty("user.dir")), "subdata.rsa.key").exists()) {
                if (new File(this.dir, "subdata.rsa.key").exists()) {
                    new File(this.dir, "subdata.rsa.key").delete();
                }
                Files.move(new File(new File(System.getProperty("user.dir")), "subdata.rsa.key").toPath(), new File(this.dir, "subdata.rsa.key").toPath(), new CopyOption[0]);
            }
            Messenger pmc = this.getServer().getMessenger();
            pmc.registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            pmc.registerIncomingPluginChannel((Plugin)this, "subservers:input", (channel, player, bytes) -> player.chat(new String(bytes, StandardCharsets.UTF_8)));
            this.reload(false);
            this.subprotocol = SubProtocol.get();
            this.subprotocol.registerCipher("DHE", (Cipher)DHE.get((int)128));
            this.subprotocol.registerCipher("DHE-128", (Cipher)DHE.get((int)128));
            this.subprotocol.registerCipher("DHE-192", (Cipher)DHE.get((int)192));
            this.subprotocol.registerCipher("DHE-256", (Cipher)DHE.get((int)256));
            this.api.name = this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Name", System.getenv("name"));
            this.server_address = this.config.get().getMap((Object)"Settings").getString((Object)"Connect-Address", System.getenv("address"));
            if (this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password", "").length() > 0) {
                this.subprotocol.registerCipher("AES", (Cipher)new AES(128, this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password")));
                this.subprotocol.registerCipher("AES-128", (Cipher)new AES(128, this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password")));
                this.subprotocol.registerCipher("AES-192", (Cipher)new AES(192, this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password")));
                this.subprotocol.registerCipher("AES-256", (Cipher)new AES(256, this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password")));
                Bukkit.getLogger().info("SubData > AES Encryption Available");
            }
            if (new File(this.dir, "subdata.rsa.key").exists()) {
                try {
                    this.subprotocol.registerCipher("RSA", (Cipher)new RSA(new File(this.dir, "subdata.rsa.key")));
                    Bukkit.getLogger().info("SubData > RSA Encryption Available");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.reconnect = true;
            Bukkit.getLogger().info("SubData > ");
            Bukkit.getLogger().info("SubData > Connecting to /" + this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Address", "127.0.0.1:4391"));
            this.connect(null);
            this.gui = new DefaultUIHandler(this);
            if (this.api.access.value > AccessMode.NO_COMMANDS.value && !this.config.get().getMap((Object)"Settings").getBoolean((Object)"API-Only-Mode", Boolean.valueOf(false)).booleanValue()) {
                this.signs = new SubSigns(this, new File(this.dir, "signs.dat"));
                CommandMap cmd = (CommandMap)Util.reflect((Field)Bukkit.getServer().getClass().getDeclaredField("commandMap"), (Object)Bukkit.getServer());
                cmd.register("subservers", (Command)new SubCommand(this, "subservers"));
                cmd.register("subservers", (Command)new SubCommand(this, "subserver"));
                cmd.register("subservers", (Command)new SubCommand(this, "sub"));
            }
            if (this.api.access.value > AccessMode.NO_INTEGRATIONS.value) {
                if (this.config.get().getMap((Object)"Settings").getBoolean((Object)"PlaceholderAPI-Ready", Boolean.valueOf(false)).booleanValue()) {
                    this.phi.start();
                }
                if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                    new PlaceholderImpl(this).register();
                }
            }
            new Metrics(this, 2334);
            AgnosticScheduler.async.repeats((Plugin)this, c -> {
                try {
                    YAMLSection tags = new YAMLSection(this.parseJSON("{\"tags\":" + Util.readAll((Reader)new BufferedReader(new InputStreamReader(new URL("https://api.github.com/repos/ME1312/SubServers-2/git/refs/tags").openStream(), Charset.forName("UTF-8")))) + '}'));
                    LinkedList<Version> versions = new LinkedList<Version>();
                    Version updversion = this.version;
                    int updcount = 0;
                    for (ObjectMap tag : tags.getMapList((Object)"tags")) {
                        versions.add(Version.fromString((String)tag.getString((Object)"ref").substring(10)));
                    }
                    Collections.sort(versions);
                    for (Version version : versions) {
                        if (version.compareTo(updversion) <= 0) continue;
                        updversion = version;
                        ++updcount;
                    }
                    if (updcount > 0) {
                        Bukkit.getLogger().info("SubServers > SubServers.Client.Bukkit v" + updversion + " is available. You are " + updcount + " version" + (updcount == 1 ? "" : "s") + " behind.");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 0L, TimeUnit.DAYS.toSeconds(2L) * 20L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void reload(boolean notifyPlugins) throws IOException {
        LinkedList<Runnable> listeners;
        this.resetDate = Calendar.getInstance().getTime().getTime();
        ConfigUpdater.updateConfig(new File(this.dir, "config.yml"));
        this.config.reload();
        if (notifyPlugins && (listeners = this.api.reloadListeners).size() > 0) {
            for (Runnable listener : listeners) {
                try {
                    listener.run();
                }
                catch (Throwable e) {
                    new InvocationTargetException(e, "Problem reloading plugin").printStackTrace();
                }
            }
        }
    }

    private void connect(Pair<DisconnectReason, DataClient> disconnect) throws IOException {
        int reconnect = this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getInt((Object)"Reconnect", Integer.valueOf(60));
        if (disconnect == null || this.reconnect && reconnect > 0 && disconnect.key() != DisconnectReason.PROTOCOL_MISMATCH && disconnect.key() != DisconnectReason.ENCRYPTION_MISMATCH) {
            long reset = this.resetDate;
            if (disconnect != null) {
                Bukkit.getLogger().info("SubData > Attempting reconnect in " + reconnect + " seconds");
            }
            AgnosticScheduler.async.repeats((Plugin)this, cancel -> {
                try {
                    if (reset == this.resetDate && (this.subdata.getOrDefault(0, null) == null || this.subdata.get(0).isClosed())) {
                        SubDataClient open = this.subprotocol.open(InetAddress.getByName(this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Address", "127.0.0.1:4391").split(":")[0]), Integer.parseInt(this.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Address", "127.0.0.1:4391").split(":")[1]));
                        if (this.subdata.getOrDefault(0, null) != null) {
                            this.subdata.get(0).reconnect(open);
                        }
                        this.subdata.put(0, open);
                        cancel.run();
                    }
                }
                catch (IOException e) {
                    Bukkit.getLogger().info("SubData > Connection was unsuccessful, retrying in " + reconnect + " seconds");
                }
            }, disconnect == null ? 0L : (long)reconnect, reconnect, TimeUnit.SECONDS);
        }
    }

    public void onDisable() {
        if (this.subdata != null) {
            try {
                this.setEnabled(false);
                this.reconnect = false;
                ArrayList<SubDataClient> temp = new ArrayList<SubDataClient>();
                temp.addAll(this.subdata.values());
                for (SubDataClient client : temp) {
                    if (client == null) continue;
                    client.close();
                    client.waitFor();
                }
                this.subdata.clear();
                this.subdata.put(0, null);
                if (this.signs != null) {
                    this.signs.save();
                }
                Messenger pmc = this.getServer().getMessenger();
                pmc.unregisterOutgoingPluginChannel((Plugin)this);
                pmc.unregisterIncomingPluginChannel((Plugin)this);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, ?> parseJSON(String json) throws Throwable {
        return (Map)this.gson.invokeExact(json, Map.class);
    }

    public void pmc(Player player, String ... message) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(stream);
        try {
            for (String m : message) {
                data.writeUTF(m);
            }
            data.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendPluginMessage((Plugin)this, "BungeeCord", stream.toByteArray());
    }
}

