/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Merger;
import net.ME1312.SubData.Client.Library.EscapedOutputStream;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStartEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStartedEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStopEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStoppedEvent;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.AgnosticScheduler;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.OfflineBlock;
import net.ME1312.SubServers.Client.Bukkit.Library.SignState;
import net.ME1312.SubServers.Client.Bukkit.SubPlugin;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class SubSigns
implements Listener {
    private final HashMap<OfflineBlock, String> data = new HashMap();
    private final HashMap<String, Location> locations = new HashMap();
    private HashMap<Location, Supplier<?>> signs = new HashMap();
    private final File file;
    private final SubPlugin plugin;
    private boolean active = false;

    SubSigns(SubPlugin plugin, File file) throws IOException {
        this.plugin = plugin;
        this.file = file;
        this.load();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void save() throws IOException {
        if (!this.data.isEmpty() || this.file.exists() && !this.file.delete()) {
            FileOutputStream raw = new FileOutputStream(this.file, false);
            EscapedOutputStream escaped = new EscapedOutputStream((OutputStream)raw, 27, new int[]{3});
            for (Map.Entry<OfflineBlock, String> sign : this.data.entrySet()) {
                raw.write(ByteBuffer.allocate(28).order(ByteOrder.BIG_ENDIAN).putLong(sign.getKey().world.getMostSignificantBits()).putLong(sign.getKey().world.getLeastSignificantBits()).putInt(sign.getKey().x).putInt(sign.getKey().y).putInt(sign.getKey().z).array());
                escaped.write(sign.getValue().getBytes(StandardCharsets.UTF_8));
                escaped.control(3);
            }
        }
    }

    private void load() throws IOException {
        if (this.file.exists()) {
            int b;
            Merger merge = new Merger(this::listen);
            FileInputStream in = new FileInputStream(this.file);
            ByteArrayOutputStream string = new ByteArrayOutputStream();
            ByteBuffer magic = ByteBuffer.allocate(28).order(ByteOrder.BIG_ENDIAN);
            boolean escaped = false;
            int i = 0;
            while ((b = in.read()) != -1) {
                if (i < 28) {
                    magic.put((byte)b);
                    ++i;
                    continue;
                }
                if (escaped) {
                    switch (b) {
                        case 27: {
                            string.write(27);
                            break;
                        }
                        case 3: {
                            magic.position(0);
                            String name = string.toString(StandardCharsets.UTF_8.name());
                            OfflineBlock location = new OfflineBlock(new UUID(magic.getLong(), magic.getLong()), magic.getInt(), magic.getInt(), magic.getInt());
                            Location loaded = location.load();
                            if (loaded == null) {
                                this.data.put(location, name);
                            } else {
                                merge.reserve();
                                AgnosticScheduler.at(loaded).runs((Plugin)this.plugin, c -> {
                                    if (loaded.getBlock().getState() instanceof Sign) {
                                        this.data.put(location, name);
                                        this.signs.put(loaded, this.translate(name));
                                        this.locations.put(name.toLowerCase(), loaded);
                                    } else {
                                        Bukkit.getLogger().warning("SubServers > Removed invalid sign data: [\"" + loaded.getWorld().getName() + "\", " + location.x + ", " + location.y + ", " + location.z + "] -> \"" + name + '\"');
                                    }
                                    merge.release();
                                });
                            }
                            magic.clear();
                            string.reset();
                            i = 0;
                            break;
                        }
                        default: {
                            string.write(27);
                            string.write(b);
                        }
                    }
                    escaped = false;
                    continue;
                }
                if (b == 27) {
                    escaped = true;
                    continue;
                }
                string.write(b);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void create(SignChangeEvent e) {
        Player player;
        String name;
        if (!e.isCancelled() && e.getLine(0).trim().equalsIgnoreCase("[SubServers]") && (name = e.getLine(1).trim()).length() > 0 && this.plugin.lang != null && (player = e.getPlayer()).hasPermission("subservers.signs")) {
            Supplier<?> translator = this.translate(name);
            Location location = e.getBlock().getLocation();
            HashMap signs = new HashMap(this.signs);
            signs.put(location, translator);
            this.data.put(new OfflineBlock(location), name);
            this.signs = signs;
            this.locations.put(name.toLowerCase(), location);
            this.listen();
            this.refresh(e.getBlock(), translator);
            Bukkit.getLogger().info("SubServers > Server sign created: [\"" + location.getWorld().getName() + "\", " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ() + "] -> \"" + name + '\"');
            player.sendMessage(this.plugin.api.getLang("SubServers", "Signs.Create"));
        }
    }

    private Supplier<?> translate(String name) {
        if (name.startsWith("::") && name.length() > 2) {
            String translated = name.substring(2).toLowerCase();
            return () -> this.plugin.phi.cache.getHosts().getOrDefault(translated, (Host)name);
        }
        if (name.startsWith(":") && name.length() > 1) {
            String translated = name.substring(1);
            return () -> {
                Pair<String, List<Server>> group = this.plugin.phi.cache.getGroup(translated);
                return group == null ? name : group;
            };
        }
        String translated = name.toLowerCase();
        return () -> this.plugin.phi.cache.getServers().getOrDefault(translated, (Server)name);
    }

    private void listen() {
        if (!this.active && !this.signs.isEmpty()) {
            this.active = true;
            this.plugin.phi.listen(this::refresh);
            this.plugin.phi.start();
        }
    }

    private void refresh() {
        if (this.plugin.lang != null) {
            for (Map.Entry<Location, Supplier<?>> sign : this.signs.entrySet()) {
                this.refresh(sign.getKey().getBlock(), sign.getValue());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void refresh(SubStartEvent e) {
        this.refresh(e.getServer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void refresh(SubStartedEvent e) {
        this.refresh(e.getServer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void refresh(SubStopEvent e) {
        this.refresh(e.getServer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void refresh(SubStoppedEvent e) {
        this.refresh(e.getServer());
    }

    private void refresh(String name) {
        this.refresh(this.plugin.phi.cache.getSubServer(name));
    }

    private void refresh(SubServer server) {
        if (server != null && this.plugin.lang != null) {
            Location location = this.locations.get(server.getName().toLowerCase());
            if (location != null) {
                this.refresh(location.getBlock(), () -> server);
            }
            for (String group : server.getGroups()) {
                location = this.locations.get(':' + group.toLowerCase());
                if (location == null) continue;
                this.refresh(location.getBlock(), this.signs.get(location));
            }
            location = this.locations.get("::" + server.getHost().toLowerCase());
            if (location != null) {
                this.refresh(location.getBlock(), this.signs.get(location));
            }
        }
    }

    private void refresh(Block block, Supplier<?> translator) {
        AgnosticScheduler.at(block).runs((Plugin)this.plugin, c -> {
            if (block.getState() instanceof Sign) {
                SignState incoming;
                String name;
                Object object = translator.get();
                int players = 0;
                Sign sign = (Sign)block.getState();
                SignState state = SignState.UNKNOWN;
                if (object instanceof Server) {
                    Server server = (Server)object;
                    state = SignState.determine(server);
                    name = server.getDisplayName();
                    players = server.getRemotePlayers().size();
                } else if (object instanceof Pair) {
                    Pair group = (Pair)object;
                    name = (String)group.key();
                    for (Server server : (List)group.value()) {
                        players += server.getRemotePlayers().size();
                        incoming = SignState.determine(server);
                        if (incoming.priority <= state.priority) continue;
                        state = incoming;
                    }
                } else if (object instanceof Host) {
                    Host host = (Host)object;
                    name = host.getDisplayName();
                    for (Server server : host.getSubServers().values()) {
                        players += server.getRemotePlayers().size();
                        incoming = SignState.determine((SubServer)server);
                        if (incoming.priority <= state.priority) continue;
                        state = incoming;
                    }
                } else if (object instanceof String) {
                    name = (String)object;
                } else {
                    return;
                }
                String[] text = this.plugin.phi.replace(null, this.plugin.api.getLang("SubServers", state.text).replace("$str$", name).replace("$int$", NumberFormat.getInstance().format(players))).split("\n", 4);
                for (int i = 0; i < 4; ++i) {
                    if (i < text.length) {
                        sign.setLine(i, text[i]);
                        continue;
                    }
                    sign.setLine(i, "");
                }
                sign.update();
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void interact(PlayerInteractEvent e) {
        Player player;
        Supplier<?> translator;
        if (!e.isCancelled() && e.getClickedBlock() != null && e.getClickedBlock().getState() instanceof Sign && (translator = this.signs.get(e.getClickedBlock().getLocation())) != null && this.plugin.lang != null && (player = e.getPlayer()).hasPermission("subservers.teleport") && (e.getAction() == Action.RIGHT_CLICK_BLOCK || !player.hasPermission("subservers.signs"))) {
            Collection<Object> servers;
            Object object = translator.get();
            if (object instanceof Server) {
                servers = Collections.singleton((Server)object);
            } else if (object instanceof Pair) {
                servers = (Collection)((Pair)object).value();
            } else if (object instanceof Host) {
                servers = ((Host)object).getSubServers().values();
            } else {
                return;
            }
            SignState state = SignState.UNKNOWN;
            ArrayList<Server> selected = new ArrayList<Server>();
            for (Server server : servers) {
                SubServer subserver;
                SignState incoming = SignState.determine(server);
                if (incoming == SignState.STOPPING || incoming == SignState.OFFLINE && (!(subserver = (SubServer)server).isEnabled() || !subserver.isAvailable() || subserver.getCurrentIncompatibilities().size() != 0)) continue;
                if (incoming.priority > state.priority) {
                    state = incoming;
                    selected.clear();
                    selected.add(server);
                    continue;
                }
                if (incoming != state) continue;
                selected.add(server);
            }
            if (selected.size() > 0) {
                Server server = (Server)selected.get(new Random().nextInt(selected.size()));
                if (state == SignState.OFFLINE) {
                    ((SubServer)server).start();
                } else {
                    player.sendMessage(this.plugin.api.getLang("SubServers", "Command.Teleport").replace("$name$", player.getName()).replace("$str$", server.getDisplayName()));
                    this.plugin.pmc(player, "Connect", server.getName());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void delete(BlockBreakEvent e) {
        if (!e.isCancelled() && e.getBlock().getState() instanceof Sign && this.signs.containsKey(e.getBlock().getLocation())) {
            Player player = e.getPlayer();
            if (player.hasPermission("subservers.signs") && this.plugin.lang != null) {
                Location location = e.getBlock().getLocation();
                String name = this.data.remove(new OfflineBlock(location));
                if (name != null) {
                    this.locations.remove(name.toLowerCase());
                }
                HashMap signs = new HashMap(this.signs);
                signs.remove(location);
                this.signs = signs;
                player.sendMessage(this.plugin.api.getLang("SubServers", "Signs.Delete"));
            } else {
                e.setCancelled(true);
            }
        }
    }
}

