/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common;

import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.DataProtocol;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Proxy;
import net.ME1312.SubServers.Client.Common.Network.API.RemotePlayer;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SimplifiedData;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketAddServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketRemoveServer;

public abstract class ClientAPI {
    private static ClientAPI api;

    protected ClientAPI() {
        api = this;
    }

    public static ClientAPI getInstance() {
        return api;
    }

    public abstract String getName();

    public void getHosts(Consumer<Map<String, Host>> callback) {
        SimplifiedData.requestHosts(null, callback);
    }

    public void getHost(String name, Consumer<Host> callback) {
        SimplifiedData.requestHost(null, name, callback);
    }

    public void getGroups(Consumer<Map<String, List<Server>>> callback) {
        SimplifiedData.requestGroups(null, callback);
    }

    public void getLowercaseGroups(Consumer<Map<String, List<Server>>> callback) {
        SimplifiedData.requestLowercaseGroups(null, callback);
    }

    public void getGroup(String name, Consumer<Pair<String, List<Server>>> callback) {
        SimplifiedData.requestGroup(null, name, callback);
    }

    public void getServers(Consumer<Map<String, Server>> callback) {
        SimplifiedData.requestServers(null, callback);
    }

    public void getServer(String name, Consumer<Server> callback) {
        SimplifiedData.requestServer(null, name, callback);
    }

    public void addServer(String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted, IntConsumer response) {
        this.addServer(null, name, ip, port, motd, hidden, restricted, response);
    }

    public void addServer(UUID player, String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        ((SubDataClient)this.getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketAddServer(player, name, ip, port, motd, hidden, restricted, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void addServer(String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted) {
        this.addServer(null, name, ip, port, motd, hidden, restricted);
    }

    public void addServer(UUID player, String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted) {
        this.addServer(player, name, ip, port, motd, hidden, restricted, i -> {});
    }

    public void removeServer(String name, IntConsumer response) {
        this.removeServer(null, name, response);
    }

    public void removeServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.removeServer(player, name, false, response);
    }

    public void removeServer(String name) {
        this.removeServer(null, name);
    }

    public void removeServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.removeServer(player, name, i -> {});
    }

    public void forceRemoveServer(String name, IntConsumer response) {
        this.forceRemoveServer(null, name, response);
    }

    public void forceRemoveServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.removeServer(player, name, true, response);
    }

    public void forceRemoveServer(String name) {
        this.forceRemoveServer(null, name);
    }

    public void forceRemoveServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.forceRemoveServer(player, name, i -> {});
    }

    private void removeServer(UUID player, String name, boolean force, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        ((SubDataClient)this.getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketRemoveServer(player, name, force, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void getSubServers(Consumer<Map<String, SubServer>> callback) {
        SimplifiedData.requestSubServers(null, callback);
    }

    public void getSubServer(String name, Consumer<SubServer> callback) {
        SimplifiedData.requestSubServer(null, name, callback);
    }

    public void getProxies(Consumer<Map<String, Proxy>> callback) {
        SimplifiedData.requestProxies(null, callback);
    }

    public void getProxy(String name, Consumer<Proxy> callback) {
        SimplifiedData.requestProxy(null, name, callback);
    }

    public void getMasterProxy(Consumer<Proxy> callback) {
        SimplifiedData.requestMasterProxy(null, callback);
    }

    public void getRemotePlayers(Consumer<Map<UUID, RemotePlayer>> callback) {
        SimplifiedData.requestRemotePlayers(null, callback);
    }

    public void getRemotePlayer(String name, Consumer<RemotePlayer> callback) {
        SimplifiedData.requestRemotePlayer(null, name, callback);
    }

    public void getRemotePlayer(UUID id, Consumer<RemotePlayer> callback) {
        SimplifiedData.requestRemotePlayer(null, id, callback);
    }

    public abstract DataClient[] getSubDataNetwork();

    public abstract DataProtocol getSubDataProtocol();

    public abstract Collection<String> getLangChannels();

    public abstract Map<String, String> getLang(String var1);

    public String getLang(String channel, String key) {
        Util.nullpo((Object[])new String[]{channel, key});
        return this.getLang(channel).get(key);
    }
}

