/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.Calendar;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.Proxy;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SimplifiedData;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDisconnectPlayer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadPlayerInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketMessagePlayer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketTransferPlayer;

public class RemotePlayer {
    protected static StaticImpl instance = new StaticImpl();
    ObjectMap<String> raw;
    private Proxy proxy = null;
    private Server server = null;
    DataClient client;
    long timestamp;

    public RemotePlayer(ObjectMap<String> raw) {
        this(null, raw);
    }

    protected RemotePlayer(DataClient client, ObjectMap<String> raw) {
        this.client = client;
        this.load(raw);
    }

    public boolean equals(Object obj) {
        return obj instanceof RemotePlayer && this.getUniqueId().equals(((RemotePlayer)obj).getUniqueId());
    }

    void load(ObjectMap<String> raw) {
        this.raw = raw;
        this.proxy = null;
        this.server = null;
        this.timestamp = Calendar.getInstance().getTime().getTime();
    }

    private SubDataClient client() {
        return SimplifiedData.client(this.client);
    }

    public void refresh() {
        UUID id = this.getUniqueId();
        this.client().sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo(Collections.singletonList(id), data -> this.load((ObjectMap<String>)data.getMap((Object)id.toString())))});
    }

    public UUID getUniqueId() {
        return this.raw.getUUID((Object)"id");
    }

    public String getName() {
        return this.raw.getString((Object)"name");
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.raw.getString((Object)"address").split(":")[0], Integer.parseInt(this.raw.getString((Object)"address").split(":")[1]));
    }

    public String getProxyName() {
        return this.raw.getString((Object)"proxy");
    }

    public void getProxy(Consumer<Proxy> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.proxy);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.proxy == null || !this.proxy.getName().equalsIgnoreCase(this.raw.getString((Object)"proxy"))) {
            ClientAPI.getInstance().getProxy(this.raw.getString((Object)"proxy"), proxy -> {
                this.proxy = proxy;
                run.run();
            });
        } else {
            run.run();
        }
    }

    public String getServerName() {
        return this.raw.getString((Object)"server");
    }

    public void getServer(Consumer<Server> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.server);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.server == null || !this.server.getName().equalsIgnoreCase(this.raw.getString((Object)"server"))) {
            ClientAPI.getInstance().getServer(this.raw.getString((Object)"server"), server -> {
                this.server = server;
                run.run();
            });
        } else {
            run.run();
        }
    }

    public static void broadcastMessage(String ... messages) {
        RemotePlayer.broadcastMessage(messages, (int i) -> {});
    }

    public static void broadcastMessage(String message, IntConsumer response) {
        RemotePlayer.broadcastMessage(new String[]{message}, response);
    }

    public static void broadcastMessage(String[] messages, IntConsumer response) {
        RemotePlayer.sendMessage(null, messages, response);
    }

    public void sendMessage(String ... messages) {
        this.sendMessage(messages, (int i) -> {});
    }

    public void sendMessage(String message, IntConsumer response) {
        this.sendMessage(new String[]{message}, response);
    }

    public void sendMessage(String[] messages, IntConsumer response) {
        instance.sendMessage(this.client(), new UUID[]{this.getUniqueId()}, messages, response);
    }

    public static void sendMessage(UUID[] players, String ... messages) {
        RemotePlayer.sendMessage(players, messages, (int i) -> {});
    }

    public static void sendMessage(UUID[] players, String message, IntConsumer response) {
        RemotePlayer.sendMessage(players, new String[]{message}, response);
    }

    public static void sendMessage(UUID[] players, String[] messages, IntConsumer response) {
        instance.sendMessage(SimplifiedData.client(ClientAPI.getInstance().getSubDataNetwork()[0]), players, messages, response);
    }

    public static void broadcastRawMessage(String ... messages) {
        RemotePlayer.broadcastRawMessage(messages, (int i) -> {});
    }

    public static void broadcastRawMessage(String message, IntConsumer response) {
        RemotePlayer.broadcastRawMessage(new String[]{message}, response);
    }

    public static void broadcastRawMessage(String[] messages, IntConsumer response) {
        RemotePlayer.sendRawMessage(null, messages, response);
    }

    public void sendRawMessage(String ... messages) {
        this.sendRawMessage(messages, (int i) -> {});
    }

    public void sendRawMessage(String message, IntConsumer response) {
        this.sendRawMessage(new String[]{message}, response);
    }

    public void sendRawMessage(String[] message, IntConsumer response) {
        instance.sendRawMessage(this.client(), new UUID[]{this.getUniqueId()}, message, response);
    }

    public static void sendRawMessage(UUID[] players, String ... messages) {
        RemotePlayer.sendRawMessage(players, messages, (int i) -> {});
    }

    public static void sendRawMessage(UUID[] players, String message, IntConsumer response) {
        RemotePlayer.sendRawMessage(players, new String[]{message}, response);
    }

    public static void sendRawMessage(UUID[] players, String[] messages, IntConsumer response) {
        instance.sendRawMessage(SimplifiedData.client(ClientAPI.getInstance().getSubDataNetwork()[0]), players, messages, response);
    }

    public void transfer(String server) {
        this.transfer(server, i -> {});
    }

    public void transfer(String server, IntConsumer response) {
        instance.transfer(this.client(), new UUID[]{this.getUniqueId()}, server, response);
    }

    public static void transfer(UUID[] players, String server) {
        RemotePlayer.transfer(players, server, i -> {});
    }

    public static void transfer(UUID[] players, String server, IntConsumer response) {
        instance.transfer(SimplifiedData.client(ClientAPI.getInstance().getSubDataNetwork()[0]), players, server, response);
    }

    public void disconnect() {
        this.disconnect((String)null);
    }

    public void disconnect(IntConsumer response) {
        this.disconnect(null, response);
    }

    public void disconnect(String reason) {
        this.disconnect(reason, i -> {});
    }

    public void disconnect(String reason, IntConsumer response) {
        instance.disconnect(this.client(), new UUID[]{this.getUniqueId()}, reason, response);
    }

    public static void disconnect(UUID ... players) {
        RemotePlayer.disconnect(players, (String)null);
    }

    public static void disconnect(UUID[] players, IntConsumer response) {
        RemotePlayer.disconnect(players, null, response);
    }

    public static void disconnect(UUID[] players, String reason) {
        RemotePlayer.disconnect(players, reason, (int i) -> {});
    }

    public static void disconnect(UUID[] players, String reason, IntConsumer response) {
        instance.disconnect(SimplifiedData.client(ClientAPI.getInstance().getSubDataNetwork()[0]), players, reason, response);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ObjectMap<String> getRaw() {
        return this.raw.clone();
    }

    protected static class StaticImpl {
        protected StaticImpl() {
        }

        protected final RemotePlayer construct(ObjectMap<String> raw) {
            return this.construct((DataClient)null, raw);
        }

        protected RemotePlayer construct(DataClient client, ObjectMap<String> raw) {
            return new RemotePlayer(client, raw);
        }

        final RemotePlayer construct(Server server, ObjectMap<String> raw) {
            RemotePlayer player = this.construct(server.client, raw);
            player.server = server;
            return player;
        }

        final RemotePlayer construct(Proxy proxy, ObjectMap<String> raw) {
            RemotePlayer player = this.construct(proxy.client, raw);
            player.proxy = proxy;
            return player;
        }

        protected void sendMessage(SubDataClient client, UUID[] players, String[] messages, IntConsumer response) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            client.sendPacket(new PacketOut[]{new PacketMessagePlayer(players, messages, null, data -> {
                try {
                    response.accept(data.getInt((Object)1));
                }
                catch (Throwable e) {
                    InvocationTargetException ew = new InvocationTargetException(e);
                    ew.setStackTrace(origin);
                    ew.printStackTrace();
                }
            })});
        }

        protected void sendRawMessage(SubDataClient client, UUID[] players, String[] messages, IntConsumer response) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            client.sendPacket(new PacketOut[]{new PacketMessagePlayer(players, null, messages, data -> {
                try {
                    response.accept(data.getInt((Object)1));
                }
                catch (Throwable e) {
                    InvocationTargetException ew = new InvocationTargetException(e);
                    ew.setStackTrace(origin);
                    ew.printStackTrace();
                }
            })});
        }

        protected void transfer(SubDataClient client, UUID[] players, String server, IntConsumer response) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            client.sendPacket(new PacketOut[]{new PacketTransferPlayer(players, server, data -> {
                try {
                    response.accept(data.getInt((Object)1));
                }
                catch (Throwable e) {
                    InvocationTargetException ew = new InvocationTargetException(e);
                    ew.setStackTrace(origin);
                    ew.printStackTrace();
                }
            })});
        }

        protected void disconnect(SubDataClient client, UUID[] players, String reason, IntConsumer response) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            client.sendPacket(new PacketOut[]{new PacketDisconnectPlayer(players, reason, data -> {
                try {
                    response.accept(data.getInt((Object)1));
                }
                catch (Throwable e) {
                    InvocationTargetException ew = new InvocationTargetException(e);
                    ew.setStackTrace(origin);
                    ew.printStackTrace();
                }
            })});
        }
    }
}

