/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.DataSender;
import net.ME1312.SubData.Client.Library.ForwardedDataSender;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.RemotePlayer;
import net.ME1312.SubServers.Client.Common.Network.API.SimplifiedData;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketCommandServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadPlayerInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadServerInfo;

public class Server {
    ObjectMap<String> raw;
    private List<RemotePlayer> players = null;
    DataClient client;
    long timestamp;

    public Server(ObjectMap<String> raw) {
        this(null, raw);
    }

    Server(DataClient client, ObjectMap<String> raw) {
        this.client = (SubDataClient)client;
        this.load(raw);
    }

    public boolean equals(Object obj) {
        return obj instanceof Server && this.getSignature().equals(((Server)obj).getSignature());
    }

    void load(ObjectMap<String> raw) {
        this.raw = raw;
        this.players = null;
        this.timestamp = Calendar.getInstance().getTime().getTime();
    }

    SubDataClient client() {
        return SimplifiedData.client(this.client);
    }

    public void refresh() {
        String name = this.getName();
        this.client().sendPacket(new PacketOut[]{new PacketDownloadServerInfo(Collections.singletonList(name), data -> this.load((ObjectMap<String>)data.getMap((Object)name)))});
    }

    public DataSender[] getSubData() {
        ObjectMap subdata = new ObjectMap((Map)this.raw.getObject((Object)"subdata"));
        Object[] keys = subdata.getKeys().toArray(new Integer[0]);
        DataSender[] channels = new DataSender[keys.length];
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            channels[i] = subdata.isNull(keys[i]) ? null : new ForwardedDataSender((SubDataClient)ClientAPI.getInstance().getSubDataNetwork()[0], subdata.getUUID(keys[i]));
        }
        return channels;
    }

    public String getName() {
        return this.raw.getString((Object)"name");
    }

    public String getDisplayName() {
        return this.raw.getString((Object)"display");
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.raw.getString((Object)"address").split(":")[0], Integer.parseInt(this.raw.getString((Object)"address").split(":")[1]));
    }

    public List<String> getGroups() {
        return this.raw.getStringList((Object)"group");
    }

    public void command(UUID player, UUID target, String command, IntConsumer response) {
        Util.nullpo((Object[])new Object[]{command, response});
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketCommandServer(player, target, this.getName(), command, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void command(UUID player, String command, IntConsumer response) {
        this.command(player, null, command, response);
    }

    public void command(String command, IntConsumer response) {
        this.command(null, command, response);
    }

    public void command(UUID player, UUID target, String command) {
        this.command(player, target, command, i -> {});
    }

    public void command(UUID player, String command) {
        this.command(player, command, (int i) -> {});
    }

    public void command(String command) {
        this.command(command, (int i) -> {});
    }

    public Collection<Pair<String, UUID>> getRemotePlayers() {
        ArrayList<Pair<String, UUID>> players = new ArrayList<Pair<String, UUID>>();
        for (String id : this.raw.getMap((Object)"players").getKeys()) {
            players.add((Pair<String, UUID>)new ContainedPair((Object)this.raw.getMap((Object)"players").getString((Object)id), (Object)UUID.fromString(id)));
        }
        return players;
    }

    public void getRemotePlayers(Consumer<Collection<RemotePlayer>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.players);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.players == null) {
            LinkedList<UUID> ids = new LinkedList<UUID>();
            for (String id : this.raw.getMap((Object)"players").getKeys()) {
                ids.add(UUID.fromString(id));
            }
            this.client().sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo((List<UUID>)ids, (Consumer<ObjectMap<String>>[])new Consumer[]{data -> {
                LinkedList<RemotePlayer> players = new LinkedList<RemotePlayer>();
                for (String player : data.getKeys()) {
                    players.add(RemotePlayer.instance.construct(this, (ObjectMap<String>)data.getMap((Object)player)));
                }
                this.players = players;
                run.run();
            }})});
        } else {
            run.run();
        }
    }

    public boolean isHidden() {
        return this.raw.getBoolean((Object)"hidden");
    }

    public String getMotd() {
        return this.raw.getString((Object)"motd");
    }

    public boolean isRestricted() {
        return this.raw.getBoolean((Object)"restricted");
    }

    public Collection<UUID> getWhitelist() {
        return this.raw.getUUIDList((Object)"whitelist");
    }

    public boolean isWhitelisted(UUID player) {
        return this.getWhitelist().contains(player);
    }

    public String getSignature() {
        return this.raw.getString((Object)"signature");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ObjectMap<String> getRaw() {
        return this.raw.clone();
    }
}

