/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubCreator;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadServerInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketEditServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketStartServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketStopServer;

public class SubServer
extends Server {
    private List<SubServer> incompatibilities = null;
    private List<SubServer> currentIncompatibilities = null;
    private Host host = null;

    public SubServer(ObjectMap<String> raw) {
        super(null, raw);
    }

    SubServer(DataClient client, ObjectMap<String> raw) {
        super(client, raw);
    }

    SubServer(Host host, ObjectMap<String> raw) {
        this(host.client, raw);
        this.host = host;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SubServer && super.equals(obj);
    }

    @Override
    public void refresh() {
        this.host = null;
        this.incompatibilities = null;
        this.currentIncompatibilities = null;
        super.refresh();
    }

    public void start(UUID player, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketStartServer(player, this.getName(), data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void start(IntConsumer response) {
        this.start(null, response);
    }

    public void start(UUID player) {
        this.start(player, i -> {});
    }

    public void start() {
        this.start((int i) -> {});
    }

    public void stop(UUID player, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketStopServer(player, this.getName(), false, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void stop(IntConsumer response) {
        this.stop(null, response);
    }

    public void stop(UUID player) {
        this.stop(player, i -> {});
    }

    public void stop() {
        this.stop((int i) -> {});
    }

    public void terminate(UUID player, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketStopServer(player, this.getName(), true, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void terminate(IntConsumer response) {
        this.terminate(null, response);
    }

    public void terminate(UUID player) {
        this.terminate(player, i -> {});
    }

    public void terminate() {
        this.terminate((int i) -> {});
    }

    public void edit(UUID player, ObjectMap<String> edit, IntConsumer response) {
        this.edit(player, edit, false, response);
    }

    public void edit(ObjectMap<String> edit, IntConsumer response) {
        this.edit(null, edit, response);
    }

    public void edit(UUID player, ObjectMap<String> edit) {
        this.edit(player, edit, i -> {});
    }

    public void edit(ObjectMap<String> edit) {
        this.edit(null, edit);
    }

    public void permaEdit(UUID player, ObjectMap<String> edit, IntConsumer response) {
        this.edit(player, edit, true, response);
    }

    public void permaEdit(ObjectMap<String> edit, IntConsumer response) {
        this.permaEdit(null, edit, response);
    }

    public void permaEdit(UUID player, ObjectMap<String> edit) {
        this.permaEdit(player, edit, i -> {});
    }

    public void permaEdit(ObjectMap<String> edit) {
        this.permaEdit(null, edit);
    }

    private void edit(UUID player, ObjectMap<String> edit, boolean perma, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketEditServer(player, this.getName(), edit, perma, data -> {
            try {
                if (data.getInt((Object)1) != 0) {
                    response.accept(data.getInt((Object)1) * -1);
                } else {
                    response.accept(data.getInt((Object)2));
                }
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public boolean isRunning() {
        return this.raw.getBoolean((Object)"running");
    }

    public boolean isOnline() {
        return this.raw.getBoolean((Object)"online");
    }

    public boolean isStopping() {
        return this.raw.getBoolean((Object)"stopping");
    }

    public String getHost() {
        return this.raw.getString((Object)"host");
    }

    public void getHost(Consumer<Host> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.host);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.host == null || !this.host.getName().equalsIgnoreCase(this.raw.getString((Object)"host"))) {
            ClientAPI.getInstance().getHost(this.raw.getString((Object)"host"), host -> {
                this.host = host;
                run.run();
            });
        } else {
            run.run();
        }
    }

    public String getTemplate() {
        return this.raw.getString((Object)"template");
    }

    public void getTemplate(Consumer<SubCreator.ServerTemplate> callback) {
        Util.nullpo(callback);
        String name = this.getTemplate();
        if (name == null) {
            callback.accept(null);
        } else {
            this.getHost(host -> callback.accept(host.getCreator().getTemplate(name)));
        }
    }

    public boolean isAvailable() {
        return this.raw.getBoolean((Object)"available");
    }

    public boolean isEnabled() {
        return this.raw.getBoolean((Object)"enabled");
    }

    public void setEnabled(boolean value) {
        this.setEnabled(value, b -> {});
    }

    public void setEnabled(boolean value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"enabled", (Object)value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"enabled", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public boolean isEditable() {
        return this.raw.getBoolean((Object)"editable");
    }

    public boolean isLogging() {
        return this.raw.getBoolean((Object)"log");
    }

    public void setLogging(boolean value) {
        this.setLogging(value, b -> {});
    }

    public void setLogging(boolean value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"log", (Object)value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"log", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public String getPath() {
        return this.raw.getString((Object)"dir");
    }

    public String getExecutable() {
        return this.raw.getString((Object)"exec");
    }

    public String getStopCommand() {
        return this.raw.getString((Object)"stop-cmd");
    }

    public void setStopCommand(String value) {
        this.setStopCommand(value, b -> {});
    }

    public void setStopCommand(String value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"stop-cmd", (Object)value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"stop-cmd", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public StopAction getStopAction() {
        return (StopAction)((Object)Try.all.get(() -> StopAction.valueOf(this.raw.getString((Object)"stop-action").toUpperCase().replace('-', '_').replace(' ', '_')), (Object)StopAction.NONE));
    }

    public void setStopAction(StopAction action) {
        this.setStopAction(action, b -> {});
    }

    public void setStopAction(StopAction action, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{action, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"stop-action", (Object)action.toString());
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"stop-action", (Object)action.toString());
            }
            response.accept(r > 0);
        });
    }

    public void toggleCompatibility(String server) {
        this.toggleCompatibility(server, b -> {});
    }

    public void toggleCompatibility(String server, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{server, response});
        ArrayList<String> value = new ArrayList<String>();
        value.addAll(this.getIncompatibilities());
        if (!value.contains(server)) {
            value.add(server);
        } else {
            value.remove(server);
        }
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"incompatible", value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"incompatible", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public boolean isCompatible(String server) {
        LinkedList<String> lowercaseIncompatibilities = new LinkedList<String>();
        for (String key : this.getIncompatibilities()) {
            lowercaseIncompatibilities.add(key.toLowerCase());
        }
        return lowercaseIncompatibilities.contains(server.toLowerCase());
    }

    public List<String> getIncompatibilities() {
        return this.raw.getStringList((Object)"incompatible-list");
    }

    public void getIncompatibilities(Consumer<List<SubServer>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.incompatibilities);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.incompatibilities == null) {
            LinkedList<String> incompatible = new LinkedList<String>();
            for (String subserver : this.raw.getStringList((Object)"incompatible-list")) {
                incompatible.add(subserver.toLowerCase());
            }
            this.client().sendPacket(new PacketOut[]{new PacketDownloadServerInfo(incompatible, data -> {
                LinkedList<SubServer> incompatibilities = new LinkedList<SubServer>();
                for (String server : data.getKeys()) {
                    if (!data.getMap((Object)server).getString((Object)"type", "Server").equals("SubServer")) continue;
                    incompatibilities.add(new SubServer((ObjectMap<String>)data.getMap((Object)server)));
                }
                this.incompatibilities = incompatibilities;
                run.run();
            })});
        } else {
            run.run();
        }
    }

    public List<String> getCurrentIncompatibilities() {
        return this.raw.getStringList((Object)"incompatible");
    }

    public void getCurrentIncompatibilities(Consumer<List<SubServer>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.currentIncompatibilities);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.currentIncompatibilities == null) {
            LinkedList<String> incompatible = new LinkedList<String>();
            for (String subserver : this.raw.getStringList((Object)"incompatible")) {
                incompatible.add(subserver.toLowerCase());
            }
            this.client().sendPacket(new PacketOut[]{new PacketDownloadServerInfo(incompatible, data -> {
                LinkedList<SubServer> incompatibilities = new LinkedList<SubServer>();
                for (String server : data.getKeys()) {
                    if (!data.getMap((Object)server).getString((Object)"type", "Server").equals("SubServer")) continue;
                    incompatibilities.add(new SubServer((ObjectMap<String>)data.getMap((Object)server)));
                }
                this.currentIncompatibilities = incompatibilities;
                run.run();
            })});
        } else {
            run.run();
        }
    }

    public void setDisplayName(String value) {
        this.setMotd(value, b -> {});
    }

    public void setDisplayName(String value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"display", (Object)(value == null ? "" : value));
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"display", (Object)(value == null ? this.getName() : value));
            }
            response.accept(r > 0);
        });
    }

    public void addGroup(String value) {
        this.addGroup(value, b -> {});
    }

    public void addGroup(String value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ArrayList<String> v = new ArrayList<String>();
        v.addAll(this.getGroups());
        if (!v.contains(value)) {
            v.add(value);
        }
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"group", v);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"group", (Object)v);
            }
            response.accept(r > 0);
        });
    }

    public void removeGroup(String value) {
        this.removeGroup(value, b -> {});
    }

    public void removeGroup(String value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ArrayList<UUID> v = new ArrayList<UUID>();
        v.addAll(this.getWhitelist());
        v.remove(value);
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"group", v);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"group", (Object)v);
            }
            response.accept(r > 0);
        });
    }

    public void setHidden(boolean value) {
        this.setHidden(value, b -> {});
    }

    public void setHidden(boolean value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"restricted", (Object)value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"restricted", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public void setMotd(String value) {
        this.setMotd(value, b -> {});
    }

    public void setMotd(String value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"motd", (Object)value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"motd", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public void setRestricted(boolean value) {
        this.setRestricted(value, b -> {});
    }

    public void setRestricted(boolean value, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{value, response});
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"restricted", (Object)value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"restricted", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public void whitelist(UUID player) {
        this.whitelist(player, b -> {});
    }

    public void whitelist(UUID player, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{player, response});
        ArrayList<UUID> value = new ArrayList<UUID>();
        value.addAll(this.getWhitelist());
        if (!value.contains(player)) {
            value.add(player);
        }
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"whitelist", value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"whitelist", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public void unwhitelist(UUID player) {
        this.unwhitelist(player, b -> {});
    }

    public void unwhitelist(UUID player, Consumer<Boolean> response) {
        Util.nullpo((Object[])new Object[]{player, response});
        ArrayList<UUID> value = new ArrayList<UUID>();
        value.addAll(this.getWhitelist());
        value.remove(player);
        ObjectMap edit = new ObjectMap();
        edit.set((Object)"whitelist", value);
        this.edit((ObjectMap<String>)edit, (int r) -> {
            if (r > 0) {
                this.raw.set((Object)"whitelist", (Object)value);
            }
            response.accept(r > 0);
        });
    }

    public static enum StopAction {
        NONE,
        RESTART,
        REMOVE_SERVER,
        RECYCLE_SERVER,
        DELETE_SERVER;


        public String toString() {
            return super.toString().substring(0, 1).toUpperCase() + super.toString().substring(1).toLowerCase().replace('_', ' ');
        }
    }
}

