/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.Packet;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.Protocol.PacketObjectIn;
import net.ME1312.SubData.Client.Protocol.PacketObjectOut;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketMessagePlayer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private UUID[] players;
    private String[] legacy;
    private String[] raw;
    private UUID id;

    public PacketMessagePlayer() {
    }

    @SafeVarargs
    public PacketMessagePlayer(UUID[] players, String[] legacy, String[] raw, Consumer<ObjectMap<Integer>> ... callback) {
        this.players = players;
        this.legacy = legacy;
        this.raw = raw;
        this.id = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.id, callback);
    }

    public ObjectMap<Integer> send(SubDataSender client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.id);
        if (this.players != null) {
            data.set((Object)1, (Object)this.players);
        }
        if (this.legacy != null) {
            data.set((Object)2, (Object)this.legacy);
        }
        if (this.raw != null) {
            data.set((Object)3, (Object)this.raw);
        }
        return data;
    }

    public void receive(SubDataSender client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

