/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.Packet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.Protocol.PacketObjectIn;
import net.ME1312.SubData.Client.Protocol.PacketObjectOut;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketUpdateServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private UUID player;
    private String name;
    private String template;
    private Version version;
    private boolean waitfor;
    private UUID tracker;

    public PacketUpdateServer() {
    }

    @SafeVarargs
    public PacketUpdateServer(UUID player, String name, String template, Version version, Consumer<ObjectMap<Integer>> ... callback) {
        this(player, name, template, version, false, callback);
    }

    @SafeVarargs
    public PacketUpdateServer(UUID player, String name, String template, Version version, boolean waitfor, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Serializable[]{name, callback});
        this.player = player;
        this.name = name;
        this.template = template;
        this.version = version;
        this.waitfor = waitfor;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    public ObjectMap<Integer> send(SubDataSender client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.tracker);
        data.set((Object)1, (Object)this.name);
        if (this.template != null) {
            data.set((Object)2, (Object)this.template);
        }
        if (this.version != null) {
            data.set((Object)3, (Object)this.version);
        }
        if (this.player != null) {
            data.set((Object)4, (Object)this.player);
        }
        if (this.waitfor) {
            data.set((Object)5, (Object)true);
        }
        return data;
    }

    public void receive(SubDataSender client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

